/*!
 * \file    xm-comm.h
 * \version 1.1.0.0
 * \date    28.07.2020
 * \author  Dr. S. Fischer, gedas deutschland GmbH
 * \author  S. Baumann, rd electronic GmbH
 * \brief   Datentyp fr Kommunikationsparameter.
 *
 */

/*!
 * \brief   Enthlt Daten zum UDP-Broadcast zur dynamischen Erkennung von Kanlen.
 */ 
typedef struct TUdpIp4Listener
{
	// IPv4-Adresse
    A_IP4				tUdpBroadcastAddress;
	// Portnummer, auf welcher Gerte lauschen (Gerte-Bindung)
    A_UINT16			unRemotePort;
	// Eigene Portnummer (Lokale Bindung)
    A_UINT16			unLocalPort;

}TUdpIp4Listener;

/*!
 * \brief   Schalter zur Auswahl entweder eines Hostnamen oder einer IPv4-Adresse.
 */ 
typedef enum TeTcpTarget
{
	// Hostname
    eTtIpName,
	// IPv4-Adresse
    eTtIp4Address
	
} TeTcpTarget;

/*!
 * \brief   Datenstrukturen zur Auswahl entweder eines Hostnamen oder einer IPv4-Adresse.
 */ 
typedef union TuTcpTarget switch (TeTcpTarget)
{
	// Hostname
    case eTtIpName		:	A_ASCIISTRING_64 sHostname;
	// IPv4-Adresse
    case eTtIp4Address	:	A_IP4 tIp4Address;
		
} TuTcpTarget;

/*!
 * \brief   Datenstrukturen mit Verbindungsdaten zu einem TCP-Kanal.
 */ 
typedef struct TTcpChannel
{
	//Name des logischen Anschlusses (Bezug Interface Channel::createparam)
	TLogicalName   logicalName;
	//zu messende physikalische Gre (Bezug Interface Channel::createparam)
    TePhysicalQuantity   ePhysicalQuantity;
	// Verbindungsdaten zum TCP-Kanal
	TuTcpTarget		tuTcpTarget;
	// Portnummer des TCP-Servers des Kanals
    A_UINT16		unPort;

}TTcpChannel;

/*!
 * \brief   Sequenze mit Datenstrukturen mit Verbindungsdaten zu mehreren TCP-Kanlen.
 */ 
typedef  sequence<TTcpChannel>   TsqTcpChannels;

/*!
 * \brief   Schalter zur Auswahl des Verfahrens zur Verbindungsaufnahme mit Kanlen.
 */ 
typedef enum TeConnectionType
{
	// UPD-Broadcast-Adresse fr lauschende Kanle
    eEptUdpIp4Listener,
	// Nutzung von TCP-Kanal-Verbindungsdaten
    eEptTcpChannels
	
} TeConnectionType;

/*!
 * \brief   Datenstrukturen zur Auswahl des Verfahrens zur Verbindungsaufnahme mit Kanlen.
 */ 
typedef union TuIoData switch (TeConnectionType)
{
	// UDP-Broadcast-Kanal fr dynamische Anmeldung von Kanlen
    case eEptUdpIp4Listener		:	TUdpIp4Listener tUdpIp4Listener;
	// Liste mit Verbindungsdaten zu TCP-Kanlen
    case eEptTcpChannels		:	TsqTcpChannels seqTcpChannels;
		
} TuIoData;