 /*****************************************************************
 ***  Part of the ASAM GDI Specification                        ***
 ***  File        : DCD4_3.h                                    ***
 ***  GDI Version : 4.3.2                                       ***
 ***  Date        : March 19, 2009 - DIT access changed version ***
 *****************************************************************/
//
//-------------------------- Start of the DCD4_3.H file -------------

// DataType Conventions

#include <gdi_data.h>                            // use of data types
//-------------------------------------------------------------------

// Versionskennung

typedef struct TA_GDI_Version
        {
         A_UINT8        uchMajorVersion;
         A_UINT8        uchMinorVersion;
        } TA_GDI_Version;

const TA_GDI_Version CA_GDI_Version = {
                                       uchMajorVersion = 4,
                                       uchMinorVersion = 3
                                      };
//-------------------------------------------------------------------


const A_UINT16     SAreaText          = 1;
const A_UINT16     SAreaError         = 2;
const A_UINT16     SAreaMessage       = 3;

//-------------------------------------------------------------------

// define constants for modules

const A_UINT16     Id_Module_Global         =  1;    // NO_MOD_SEL
const A_UINT16     Id_Module_Control        =  0;    // ZERO
const A_UINT16     Id_Module_DevicePresence =  8;
const A_UINT16     Id_Module_DevComParams   =  9;
//-------------------------------------------------------------------


//define constants for strings and arrays
const A_UINT16     CComp_Name         = 32;
const A_UINT16     CComp_Anz          = 20;
const A_UINT16     CDit_Anz           =255;    // DIT access changed version

//-------------------------------------------------------------------


// Declaration of the APIHND data type

typedef A_UINT32 APIHND;
//-------------------------------------------------------------------

typedef A_ASCII  ASCIISTRING_5   [6];


// Declaration of types for THeader

typedef struct TDits
    {                                            // Key in accordance with
        ASCIISTRING_5            szDitLanguage;  // ISO 639 language symbols and
                                                 // ISO 3166 country symbols separated by '_'
                                                 // DIT access changed version
        A_ASCIISTRING_32         szDIT;          // File name of the DIT file
    } TDits;

typedef sequence    <A_ASCII, CComp_Name> szCompName;
//-------------------------------------------------------------------


// Declaration of the THeader structure:

typedef struct THeader
    {
        A_UINT32                    ulDeviceVersion;
        A_ASCIISTRING_255           szDriverName;
        A_UINT32                    ulDriverVersion;
        A_ASCIISTRING_255           szFactory;
        TDits                       aDIT [CDit_Anz];    // DIT access changed version
        szCompName                  aCompanion [CComp_Anz];
        TA_GDI_Version              GDI_DCD_Version;
    } THeader;
//-------------------------------------------------------------------


// Declaration of the TConnObjFct_Data-Structure:
// This structure is to be used for the input data of the COF

typedef struct TConnObjFctData
    {
        APIHND    Src_VdHnd;
        APIHND    Src_FctHnd;
        A_INT32   Src_DeclarationNo;
        APIHND    Dest_VdHnd;
        APIHND    Dest_FctHnd;
        A_INT32   Dest_DeclarationNo;
    } TConnObjFctData;
//-------------------------------------------------------------------



module Control  {                                // Start Control VD

   // Declaration of the DeviceBaseFct:

   interface DeviceBaseFct                       // Specify all operations
    {           void ConnectObjectFunction ();   // as Forward declaration
    } :: Id(1);
//-------------------------------------------------------------------


// Declaration of the TransitionFct:

   interface TransitionFct
    {           void StartDefinition  ( in APIHND VdHandle) :: Id (11);
                void EndDefinition    ( in APIHND VdHandle) :: Id (12);
                void AddDefinition    ( in APIHND VdHandle) :: Id (13);
                void StartWorking     ( in APIHND VdHandle) :: Id (14);
                void EndWorking       ( in APIHND VdHandle) :: Id (15);
                void ChangeDefinition ( in APIHND VdHandle) :: Id (16);
                void ClearAllObject   ( in APIHND VdHandle) :: Id (17);
    } :: Id(2);


                } :: Id (Id_Module_Control);     // End Control VD


//---------------------------- End of the DCD4_3.H file -------------
