﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl"/>
	<!-- %version: 37 %  (for a complete list use Synergy/CCM) -->
    <!-- 29.04.2025 V38: CCB3116: Mark UDTC 'Fault_Unjustified' in 'EcufaultConventionalType' -->
	<!-- **************************************************************************************************************************** -->
	<!-- template T_eventmemory_long -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_eventmemory_long">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_eventmemory_long" /></p>
		<!-- only the first EcuTrace -->
		<xsl:choose>
			<xsl:when
				test="count(guided_fault_finding/diagnosis_log/EcuTrace[EcuTrace_number = '1']) > 0">
				<xsl:for-each
					select="guided_fault_finding/diagnosis_log/EcuTrace[EcuTrace_number = '1']">
					<xsl:call-template name="T_Ecus" />
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<p><xsl:value-of select="$Text_no_more_ecu_traces" /></p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_eventmemory_short -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_eventmemory_short">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_eventmemory_short" /></p>
		<!-- alle EcuTraces except the first one -->
		<xsl:choose>
			<xsl:when
				test="count(guided_fault_finding/diagnosis_log/EcuTrace[EcuTrace_number != '1']) > 0">
				<xsl:for-each
					select="guided_fault_finding/diagnosis_log/EcuTrace[EcuTrace_number != '1']">
					<p class="p_small" />
					<xsl:call-template name="func_treeView_mark_start">
					<xsl:with-param name="id">ecutrace_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
								</xsl:call-template>
					<xsl:call-template name="func_treeView_label">
					<xsl:with-param name="id">ecutrace_<xsl:value-of select="generate-id(.)" /></xsl:with-param>		
						<xsl:with-param name="label">
							<p class="header_style_middle_bu_12"><xsl:value-of select="$Text_eventmemory_number" />:&#160;<xsl:value-of select="./EcuTrace_number" /></p>
						</xsl:with-param>
					</xsl:call-template>

					<span class="treeView_content">
						<xsl:call-template name="T_Ecus" />
					</span>
					<xsl:call-template name="func_treeView_stop" />
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<p>
					<xsl:value-of select="$Text_no_more_ecu_traces" /></p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_Ecu -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_Ecus">
		<xsl:param name="withEvents" select="true()" />
		<xsl:for-each select="Ecu">
			<p class="p_small" />
			<!-- headline -->
			<p class="default_style_bu">
				<xsl:value-of select="$Text_ecu_adress" />:&#160;<xsl:value-of select="./@adresse" />&#160;<xsl:value-of select="$Text_ecu_systemname" />:&#160;<xsl:value-of select="./@systemname" /><xsl:if test="string-length(./@variant) &gt; 0">&#160;<xsl:value-of select="$Text_ecu_variant" />:&#160;<xsl:value-of select="./@variant" />&#160;</xsl:if>
				<xsl:if test="$withEvents">
					<xsl:if test="count(./Ecufault)> 0">
					<ins style="color:red">(<xsl:value-of select="$Text_ecu_eventmemory_summary" />:&#160;<xsl:value-of select="count(./Ecufault)" />)</ins>
					</xsl:if>

					<xsl:if test="count(./Ecufault)= 0 and not(@dtcReadState = 'FAILED') and not(@dtcReadState = 'NOT_RESPONDING')">
						<ins style="color:green">(<xsl:value-of select="$Text_ecu_eventmemory_summary" />:&#160;<xsl:value-of select="count(./Ecufault)" />)</ins>
					</xsl:if>
					
					<xsl:if test="@dtcReadState = 'FAILED' or @dtcReadState = 'NOT_RESPONDING'">
						<ins style="color:red">(<xsl:value-of select="$Text_ecu_eventmemory_summary" />:&#160;?)</ins>
					</xsl:if>
				</xsl:if>
			</p>

			<xsl:if test="@dtcReadState = 'FAILED'">
				<div style="margin-left:5mm">
					<p class="eventmemory_subheadline">
						<xsl:value-of select="$Text_dtc_read_failed_hint" />
					</p>
				</div>
			</xsl:if>
			<xsl:if test="@dtcReadState = 'NOT_RESPONDING'">
				<div style="margin-left:5mm">
					<p class="eventmemory_subheadline">
						<xsl:value-of select="$Text_dtc_read_not_responding_hint" />
					</p>
				</div>
			</xsl:if>

			<div style="margin-left:5mm">
				<xsl:choose>
					<xsl:when test="@systemname != '---'">
						<!-- data -->
						<xsl:call-template name="func_treeView_mark_start">
							<xsl:with-param name="id">ecuIdent_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
						</xsl:call-template>
						<table>
							<tr>
								<td>
									<p class="eventmemory_subheadline">
										<xsl:call-template name="func_treeView_label">
											<xsl:with-param name="id">ecuIdent_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
											<xsl:with-param name="label"><xsl:value-of select="$Text_ecu_identification_group" />:</xsl:with-param>
										</xsl:call-template></p>
								</td>
							</tr>				
						</table>
						<table class="treeView_content">
							<xsl:call-template name="T_EcuIdent">
								<xsl:with-param name="P_Bussystem" select="'Main'" />
							</xsl:call-template>
						</table>
						<xsl:call-template name="func_treeView_stop" />
						
						<!-- Ecu subbussystems -->
					 	<xsl:if test="count(./Subbussystem)> 0">
					 	<xsl:call-template name="func_treeView_mark_start" />
					 	<table>
					 		<tr>
					 			<!-- <td style="width:5mm">&#160;</td> -->
					 			<td>
					 				<p class="eventmemory_subheadline"> 
										<xsl:call-template name="func_treeView_label">
											<xsl:with-param name="label"><xsl:value-of select="$Text_ecu_subsystems_group" />:</xsl:with-param>
										</xsl:call-template></p>
								</td>
							</tr>
						</table>
						</xsl:if>		
						
						<span class="treeView_content">
							<xsl:for-each select="./Subbussystem">
								<xsl:choose>
									<xsl:when test="@classzero=0">
										<!-- headline -->
										<table>
											<tr>
												<td>
													<p class="eventmemory_subsubheadline">
														<xsl:value-of select="$Text_ecu_subbussystem" /></p>
												</td>
											</tr>
											<tr>
												<td>
													<p>
														<xsl:value-of select="$Text_ecu_subbussystem_no_data" /></p>
												</td>
											</tr>
										</table>
									</xsl:when>
									<xsl:otherwise>
										<!-- headline -->
										<table>
											<tr>
												<td>
													<p class="eventmemory_subsubheadline">
														<xsl:value-of select="$Text_ecu_subbussystem" /></p>
												</td>
											</tr>
										</table>
										<table class="treeView_content" style="display:block;">
											<xsl:call-template name="T_EcuIdent">
												<xsl:with-param name="P_Bussystem" select="'Sub'" />
											</xsl:call-template>
											<tr>
												<td>
												    <p>
												        <xsl:value-of select="$Text_ecu_subbussystem_programming_hash" />
												    </p>
												</td>
												<td>
												    <p class="p_word-wrap">
												        <xsl:value-of select="programmingHash" />
												    </p>
												</td>
											</tr>
											<tr>
											    <td>
												    <p>
												        <xsl:value-of select="$Text_ecu_subbussystem_configuration_hash" />
												    </p>
												</td>
												<td>
												    <p class="p_word-wrap">
												        <xsl:value-of select="configurationHash" />
												    </p>
												</td>
											</tr>
										</table>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</span>
						<xsl:call-template name="func_treeView_stop" />
						<!-- Event memory data -->
						<xsl:call-template name="T_eventmemory_data" />
					</xsl:when>
					<xsl:otherwise>
						<p>
							<xsl:value-of select="$Text_ecu_no_data" />
						</p>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</xsl:for-each>
	</xsl:template>

  <!-- **************************************************************************************************************************** -->
  <!-- template T_EcuIdentDef (use apply template by type), default ECU representation -->
  <!-- **************************************************************************************************************************** -->
  <xsl:template match="Ecuident[@xsi:type='EcuidentConventionalType']">
    <xsl:param name="base_variant_ASAM" />
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_hw_partnumber"/>:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="hw_partnumber"/>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_sw_partnumber"/>:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="sw_partnumber"/>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_hw_versionnumber"/>:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="hw_versionnumber"/>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_sw_versionnumber"/>:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="sw_versionnumber"/>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_manufacturing_date"/>:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="manufacturing_date"/>
        </p>
      </td>
    </tr>

    <!-- Different Coding behaviour for short and long coodings, as well as for print or html documents. -->
    <xsl:choose>
      <xsl:when test="codingtype = 'SHORT'">
        <tr>
          <!-- <td>&#160;</td> -->
          <td>
            <p>
              <xsl:value-of select="$Text_ecu_coding" />:
            </p>
          </td>
          <td>
            <p class="p_word-wrap">
              <xsl:value-of select="coding" />
            </p>
          </td>
        </tr>
      </xsl:when>
      <xsl:when test="codingtype = 'LONG'">
        <tr class="hidden_in_html_protocol">
          <xsl:variable name="displayByteLimit" select="30"/>
          <!-- <td>&#160;</td> -->
          <td>
            <p>
              <xsl:value-of select="$Text_ecu_coding" />:
            </p>
          </td>
          <td>
            <xsl:variable name="codingValue" select="coding"/>
            <p class="p_word-wrap">
              <xsl:if test="string-length($codingValue) &gt; $displayByteLimit">
                <xsl:call-template name="add_whitespaces_to_hex_value">
                  <xsl:with-param name="hexValue" select="substring($codingValue, 1, $displayByteLimit)" />
                </xsl:call-template>[...]
              </xsl:if>
              <xsl:if test="string-length($codingValue) &lt; ($displayByteLimit - 1)">
                <xsl:call-template name="add_whitespaces_to_hex_value">
                  <xsl:with-param name="hexValue" select="$codingValue" />
                </xsl:call-template>
              </xsl:if>
            </p>
          </td>
        </tr>
        <tr class="hidden_in_print_protocol">
          <td style="vertical-align:top">
            <p>
              <xsl:value-of select="$Text_ecu_coding"/>:
            </p>
          </td>
          <td>
            <xsl:call-template name="func_treeView_mark_start">
              <xsl:with-param name="id">
                ecuCoding_<xsl:value-of select="generate-id(.)" />
              </xsl:with-param>
            </xsl:call-template>
            <table>
              <tr>
                <td>
                  <xsl:call-template name="func_treeView_label">
                    <xsl:with-param name="id">
                      ecuCoding_<xsl:value-of select="generate-id(.)" />
                    </xsl:with-param>
                    <xsl:with-param name="label">
                      <br/>
                    </xsl:with-param>
                  </xsl:call-template>
                </td>
              </tr>
            </table>
            <table class="treeView_content">
              <thead>
                <tr>
                  <th>
                    <p>
                      <xsl:value-of select="$Text_ecu_coding_index"/>
                    </p>
                  </th>
                  <th>
                    <p>
                      <xsl:value-of select="$Text_ecu_coding_byte"/>
                    </p>
                  </th>
                  <th>
                    <p>
                      <xsl:value-of select="$Text_ecu_coding_hex_value"/>
                    </p>
                  </th>
                  <th>
                    <p>
                      <xsl:value-of select="$Text_ecu_coding_bin_value"/>
                    </p>
                  </th>
                </tr>
              </thead>

              <xsl:variable name="byteCount">
                <xsl:value-of select="(string-length(./coding)) div 2" />
              </xsl:variable>
              <xsl:call-template name="fill_coding_table">
                <xsl:with-param name="left" select="1" />
                <xsl:with-param name="right" select="$byteCount" />
                <xsl:with-param name="content" select="coding" />
              </xsl:call-template>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <p>
              <xsl:value-of select="$Text_ecu_coding" />:
            </p>
          </td>
          <td>
            <p class="p_word-wrap">
              <xsl:value-of select="coding" />
            </p>
          </td>
        </tr>
      </xsl:when>
      <!-- Older documents may not have the coding type. Display the coding value anyway. -->
      <xsl:otherwise>
        <tr>
          <!-- <td>&#160;</td> -->
          <td>
            <p>
              <xsl:value-of select="$Text_ecu_coding" />:
            </p>
          </td>
          <td>
            <p class="p_word-wrap">
              <xsl:value-of select="coding" />
            </p>
          </td>
        </tr>
      </xsl:otherwise>
    </xsl:choose>

    <tr>
      <!-- <td>&#160;</td> -->
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_flashable" />:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:choose>
            <xsl:when test="flashable='-1'">
              <xsl:value-of select="$Text_unknown" />
            </xsl:when>
            <xsl:when test="flashable='1'">
              <xsl:value-of select="$Text_flashable" />
            </xsl:when>
            <xsl:when test="flashable='0'">
              <xsl:value-of select="$Text_not_flashable" />
            </xsl:when>
            <xsl:when test="string-length(flashable)=0">
              <xsl:value-of select="$Text_unknown" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="flashable" />
            </xsl:otherwise>
          </xsl:choose>
        </p>
      </td>
    </tr>
    <tr>
      <td>
        <p>
          <xsl:value-of select="$Text_ecu_name" />:
        </p>
      </td>
      <td>
        <p class="p_word-wrap">
          <xsl:value-of select="name" />
        </p>
      </td>
    </tr>

    <xsl:if test="string-length($base_variant_ASAM) &gt; 0">
      <xsl:if test="not(contains($base_variant_ASAM, 'value not available'))">
        <tr>
          <td style="width:60mm">
            <p>
              <xsl:value-of select="$Text_ecu_base_variant_asam" />:
            </p>
          </td>
          <td>
            <p class="p_word-wrap">
              <xsl:value-of select="$base_variant_ASAM" />
            </p>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>

    <xsl:if test="string-length(asam_odx_file_identifier) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_asam_odx_file_identifier" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="asam_odx_file_identifier" />
          </p>
        </td>
      </tr>
    </xsl:if>


    <xsl:if test="string-length(asam_odx_file_version) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_asam_odx_file_version" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="asam_odx_file_version" />
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="string-length(used_asam_odx_file) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_used_asam_odx_file" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="used_asam_odx_file" />
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if
			test="string-length(VWDataSetNumberOrECUDataContainerNumber) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_VWDataSetNumberOrECUDataContainerNumber" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="VWDataSetNumberOrECUDataContainerNumber" />
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="string-length(VWDataSetVersionNumber) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_VWDataSetVersionNumber" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="VWDataSetVersionNumber" />
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if
			test="string-length(VehicleEquipmentCodeAndPRNumberCombination) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of
							select="$Text_ecu_VehicleEquipmentCodeAndPRNumberCombination" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of
							select="VehicleEquipmentCodeAndPRNumberCombination" />
          </p>
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="string-length(VWWorkshopSystemName) &gt; 0">
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_ecu_VWWorkshopSystemName" />:
          </p>
        </td>
        <td>
          <p class="p_word-wrap">
            <xsl:value-of select="VWWorkshopSystemName" />
          </p>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <!-- **************************************************************************************************************************** -->
  <!-- template T_EcuIdentCyc (use apply template by type), specific for Cyclone -->
  <!-- **************************************************************************************************************************** -->
  <xsl:template match="Ecuident[@xsi:type='EcuidentCycType']">
    <xsl:param name="base_variant_ASAM" />

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_ecu_sw_number" />
      <xsl:with-param name="value" select="CycEcuSWNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_ecu_core_assembly_number" />
      <xsl:with-param name="value" select="CycEcuCoreAssemblyNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_ecu_delivery_assembly_number" />
      <xsl:with-param name="value" select="CycEcuDeliveryAssemblyNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_sub_diag_spec_number" />
      <xsl:with-param name="value" select="CycSubDiagSpecNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_diag_spec_version" />
      <xsl:with-param name="value" select="CycDiagSpecVersion" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_nos_msg_version_number" />
      <xsl:with-param name="value" select="CycNosMsgVersionNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_vehicle_ident_number" />
      <xsl:with-param name="value" select="CycVehicleIdentNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_serial_number" />
      <xsl:with-param name="value" select="CycSerialNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_calibration_number" />
      <xsl:with-param name="value" select="CycCalibrationNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_ext_hardware_number" />
      <xsl:with-param name="value" select="CycExternalHardwareNumber" />
    </xsl:call-template>

    <xsl:call-template name="T_AddIdentRow">
      <xsl:with-param name="valueName" select="$Text_cyc_hardware_number" />
      <xsl:with-param name="value" select="CycHardwareNumber" />
    </xsl:call-template>
  </xsl:template>

  <!-- **************************************************************************************************************************** -->
	<!-- template T_EcuIdent -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_EcuIdent">
		<xsl:param name="P_Bussystem" />
		<tr>
			<td>
				<p>
					<xsl:value-of select="$Text_source" />:
				</p>
			</td>
			<td>
				<p class="p_word-wrap">
					<xsl:call-template name="translate_Data_Source">
						<xsl:with-param name="dataSource">
							<xsl:value-of select="./Ecuident/ecu_data_source" />
						</xsl:with-param>
					</xsl:call-template>
				</p>
			</td>
		</tr>

		<!-- switch to different ecuident types -->
		<xsl:apply-templates select="Ecuident">
			<xsl:with-param name="base_variant_ASAM"
				select="@base_variant_ASAM" />
		</xsl:apply-templates>
	</xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- template T_AddIdentRow (adds table row with two colums for the provided values) -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_AddIdentRow">
	  <xsl:param name="valueName"/>
	  <xsl:param name="value"/>
	  <xsl:if test="$value and not($value='')">
		<tr>
		  <td>
			<p>
			  <xsl:value-of select="$valueName"/>:
			</p>
		  </td>
		  <td>
			<p class="p_word-wrap">
			  <xsl:value-of select="$value"/>
			</p>
		  </td>
		</tr>
	  </xsl:if>
	</xsl:template>

  <!-- **************************************************************************************************************************** -->
  <!-- template T_EcufaultDef (use apply template by type), default ECU FAULT representation -->
  <!-- **************************************************************************************************************************** -->
  <xsl:template match="Ecufault[@xsi:type='EcufaultConventionalType']">
      <table>
        <tr>
          <td>
            <p class="eventmemory_subsubheadline">
              <xsl:value-of select="$Text_ecu_eventmemory_data" />
            </p>
          </td>
        </tr>
        <!--<tr> <td>&#160;</td> <td> <p> <xsl:value-of 
							select="$Text_eventmemory_list"/> </p> </td> <td> <p> 
							<xsl:value-of select="./@list"/> </p> </td> </tr> -->
        <tr>
          <!-- <td>&#160;</td> -->
          <td>
            <p>
              <xsl:value-of select="$Text_eventmemory_no" />:
            </p>
          </td>
          <td>
            <p>
              <xsl:if test="count(./Fault_Code) > 0">
                <xsl:value-of disable-output-escaping="yes" select="./Fault_Code"/>:&#160;
              </xsl:if>
              <xsl:value-of disable-output-escaping="yes"
                select="./Fault_Number" />
              <xsl:if test="./Fault_Unjustified = 'true'">
                &#160;&#040;<xsl:value-of select="$Text_eventmemory_fault_unjustified" />&#041;
              </xsl:if> 
            </p>
          </td>
        </tr>
        <xsl:if test="string-length(./Fault_Type_Number1) &gt; 0">
          <tr>
            <!-- <td>&#160;</td> -->
            <td>
              <p>
                <xsl:value-of select="$Text_eventmemory_fault_type_number_1" />:
              </p>
            </td>
            <td>
              <p>
                <xsl:value-of select="./Fault_Type_Number1" />
              </p>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="string-length(./Fault_Type_Number2) &gt; 0">
          <tr>
            <!-- <td>&#160;</td> -->
            <td>
              <p>
                <xsl:value-of select="$Text_eventmemory_fault_type_number_2" />:
              </p>
            </td>
            <td>
              <p>
                <xsl:value-of select="./Fault_Type_Number2" />
              </p>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="string-length(./fault_symptom) &gt; 0">
          <xsl:if test="not(contains(./fault_symptom, 'value not available'))">
            <tr>
              <!-- <td>&#160;</td> -->
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_symptom" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./fault_symptom" />
                </p>
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
        <xsl:if test="string-length(./dtc_text) &gt; 0">
          <tr>
            <!-- <td>&#160;</td> -->
            <td>
              <p>
                <xsl:value-of select="$Text_eventmemory_dtctext" />
              </p>
            </td>
            <td>
              <p>
                <xsl:value-of select="./dtc_text" />
              </p>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="string-length(./fault_status) &gt; 0">
          <xsl:if test="not(contains(./fault_status, 'value not available'))">
            <tr>
              <!-- <td>&#160;</td> -->
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_status" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./fault_status" />
                </p>
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
      </table>
      <!-- event memory default values -->
      <xsl:if test="count(Fault_Default_Values) > 0">


        <xsl:call-template name="func_treeView_mark_start">
          <xsl:with-param name="id">
            evenmemory_default_<xsl:value-of select="generate-id(.)" />
          </xsl:with-param>
        </xsl:call-template>
        <table>
          <tr >
            <td>
              <p class="eventmemory_subsubsubheadline">
                <xsl:call-template name="func_treeView_label">
                  <xsl:with-param name="id">
                    evenmemory_default_<xsl:value-of select="generate-id(.)" />
                  </xsl:with-param>
                  <xsl:with-param name="label">
                    <xsl:value-of select="$Text_eventmemory_default_values" />:
                  </xsl:with-param>
                </xsl:call-template>
              </p>
            </td>
          </tr>
        </table>
        <span class="treeView_content">
          <table>
            <col width="180mm"/>
            <!-- 						  <caption>
							  <p class="eventmemory_subsubsubheadline">
							  <xsl:value-of select="$Text_eventmemory_default_values" />:
							  </p>
							  </caption> -->
            <tr>
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_default_values_date" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Date" />
                </p>
              </td>
            </tr>
            <tr>
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_default_values_time" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Time" />
                </p>
              </td>
            </tr>
            <tr>
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_default_values_mileage" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Mileage" />
                </p>
              </td>
            </tr>
            <tr>
              <td>
                <p>
                  <xsl:value-of select="$Text_eventmemory_default_values_priority" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Priority" />
                </p>
              </td>
            </tr>
            <tr>
              <td>
                <p>
                  <xsl:value-of
										select="$Text_eventmemory_default_values_error_frequency" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Error_Frequency" />
                </p>
              </td>
            </tr>
            <tr>
              <td>
                <p>
                  <xsl:value-of
										select="$Text_eventmemory_default_values_unlearn_counter" />:
                </p>
              </td>
              <td>
                <p>
                  <xsl:value-of select="./Fault_Default_Values/Unlearn_Counter" />
                </p>
              </td>
            </tr>
          </table>
        </span>
      </xsl:if>
      <!-- fault environment -->
      <xsl:if test="count(Fault_Environment) > 0">
        <xsl:call-template name="func_treeView_mark_start">
          <xsl:with-param name="id">
            evenmemory_environment_<xsl:value-of select="generate-id(.)" />
          </xsl:with-param>
        </xsl:call-template>
        <table>
          <tr >
            <td>
              <p class="eventmemory_subsubsubheadline">
                <xsl:call-template name="func_treeView_label">
                  <xsl:with-param name="id">
                    evenmemory_environment_<xsl:value-of select="generate-id(.)" />
                  </xsl:with-param>
                  <xsl:with-param name="label">
                    <xsl:value-of select="$Text_eventmemory_environment" />:
                  </xsl:with-param>
                </xsl:call-template>
              </p>
            </td>
          </tr>
        </table>

        <span class="treeView_content">
          <table>
            <col style="width:270px"/>
            <xsl:for-each select="./Fault_Environment">
              <tr>
                <td>
    			  <xsl:choose>
                    <xsl:when test="./Value = '' or substring(./Value, string-length(./Value), 1) = ')'">
					   <p class="general_information_type_title"><xsl:value-of select="./Type" /></p>
					</xsl:when>
                  	<xsl:otherwise>
					   <p><xsl:value-of select="./Type" /></p>                 	  
					</xsl:otherwise>
                 </xsl:choose>
                </td>
                <td>
                  <div>
                    <xsl:value-of select="./Value" />
                  </div>
                </td>
                <td>
                  <div>
                    <xsl:value-of select="./Scale" />
                  </div>
                </td>
              </tr>
              <xsl:for-each select="./Fault_Environment_Snapshot">
                <tr>
                  <td>
                    <p>
                      <xsl:value-of select="$Text_eventmemory_snapshot" />&#160;<xsl:value-of select="./Number" />
                    </p>
                  </td>
                  <td>
                    <div>
                      <xsl:value-of select="./Value" />
                    </div>
                  </td>
                  <td>
                    <div>
                      <xsl:value-of select="./Scale" />
                    </div>
                  </td>
                </tr>
              </xsl:for-each>
            </xsl:for-each>
          </table>
        </span>
      </xsl:if>
  </xsl:template>

  <!-- **************************************************************************************************************************** -->
  <!-- template T_EcufaultCyc(use apply template by type), specific for Cyclone -->
  <!-- **************************************************************************************************************************** -->
  <xsl:template match="Ecufault[@xsi:type='EcufaultCycType']">
    <table>
      <tr>
        <td>
          <p class="eventmemory_subsubheadline">
            <xsl:value-of select="$Text_ecu_eventmemory_data" />
          </p>
        </td>
        <td></td>
      </tr>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_dtc"/>
        <xsl:with-param name="value" select="Trouble_Code"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_dtc_text"/>
        <xsl:with-param name="value" select="Trouble_Code_Text"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_dtc_value"/>
        <xsl:with-param name="value" select="Trouble_Code_Value"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_eventmemory_fault_type_number_2"/>
        <xsl:with-param name="value" select="Fault_Type_Number2"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_dtc_state"/>
        <xsl:with-param name="value" select="fault_status"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_eventmemory_default_values_date"/>
        <xsl:with-param name="value" select="Timestamp"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_eventmemory_default_values_mileage"/>
        <xsl:with-param name="value" select="Mileage"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_cycle_counter"/>
        <xsl:with-param name="value" select="Operation_Cycle_Counter"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_snapshot_number"/>
        <xsl:with-param name="value" select="Snapshot_Number"/>
      </xsl:call-template>
      <xsl:call-template name="T_AddIdentRow">
        <xsl:with-param name="valueName" select="$Text_cyc_freezedata_field"/>
        <xsl:with-param name="value" select="FreezeDataBytefield"/>
      </xsl:call-template>
      <tr>
        <td>
          <p>
            <xsl:value-of select="$Text_cyc_freezedata_value" />:
          </p>
        </td>
        <td>
          <p>
            <xsl:apply-templates select="FreezeDataStringTable"/>
          </p>
        </td>
      </tr>
    </table>
    </xsl:template>

  <!-- **************************************************************************************************************************** -->
  <!-- template to display the cyclone specific FreezeDataStringTable (xpath: EcuTrace/Ecu/Ecufault/FreezeDataStringTable) -->
  <!-- **************************************************************************************************************************** -->
  <xsl:template match="FreezeDataStringTable">
    <table>
      <xsl:for-each select="FreezeDataElement">
        <tr>
          <td>
            <xsl:value-of select="@pos"/>
          </td>
          <td>
            <xsl:value-of select="@name"/>
          </td>
          <td>
            <xsl:value-of select="@value"/>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>
                
  <!-- **************************************************************************************************************************** -->
	<!-- template T_eventmemory_data -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_eventmemory_data">
    <xsl:param name="ecuSource" select="./Ecufault[1]/Fault_Data_Source"/>
		<xsl:if test="count(./Ecufault)> 0">
			<xsl:call-template name="func_treeView_mark_start">
				<xsl:with-param name="id">evenmemory_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
			</xsl:call-template>
			<table>
				<tr>
					<td>
						<p class="eventmemory_subheadline">
							<xsl:call-template name="func_treeView_label">
								<xsl:with-param name="id">evenmemory_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
								<xsl:with-param name="label">
								<xsl:value-of select="$Text_ecu_eventmemory_group" />
								<ins style="font-size:8pt; font-weight:normal; text-decoration:none">
				                    <xsl:text> (</xsl:text>
				                    <xsl:value-of select="$Text_source"/>
				                    <xsl:text>: </xsl:text>
				                    <xsl:call-template name="translate_Data_Source">
				                      <xsl:with-param name="dataSource">
				                        <xsl:value-of select="$ecuSource"/>
				                      </xsl:with-param>
				                    </xsl:call-template>
				                    <xsl:text>)</xsl:text>
			                    </ins>
			                   <xsl:text>:</xsl:text>
							   </xsl:with-param>
						  </xsl:call-template></p>
					</td>
				</tr>
			</table>

      <!-- ecufault uses own templates by xsi type -->
			<span class="treeView_content">
				<xsl:for-each select="./Ecufault">
          <xsl:apply-templates select="."/>
				</xsl:for-each>
			</span>
			<xsl:call-template name="func_treeView_stop" />
		</xsl:if>
	</xsl:template>

  <xsl:template name="translate_Data_Source">
    <xsl:param name="dataSource"/>
    <xsl:choose>
      <xsl:when test="$dataSource = 'Backend'">
        <xsl:value-of select="$Text_source_backend"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$Text_source_vehicle"/>
      </xsl:otherwise>
    </xsl:choose>      
  </xsl:template>
  
	<xsl:template name="decimal_to_hex">
  		<xsl:param name="decimalNumber"/>
  		<xsl:variable name="hexDigits" select="'0123456789ABCDEF'"/>
  		<xsl:if test="$decimalNumber &gt;= 16">
  			<xsl:call-template name="decimal_to_hex">
				<xsl:with-param name="decimalNumber" select="(floor($decimalNumber div 16))" />
  			</xsl:call-template>
  		</xsl:if>
  		<xsl:value-of select="substring($hexDigits, ($decimalNumber mod 16) + 1, 1)"/>
	</xsl:template>

	<xsl:template name="hex_to_binary">
		<xsl:param name="hex"/>
		<xsl:if test="$hex">
			<xsl:variable name="first" select="substring($hex, 1, 1)"/>
			<xsl:choose>
				<xsl:when test="$first='0'">0000</xsl:when>
				<xsl:when test="$first='1'">0001</xsl:when>
				<xsl:when test="$first='2'">0010</xsl:when>
				<xsl:when test="$first='3'">0011</xsl:when>
				<xsl:when test="$first='4'">0100</xsl:when>
				<xsl:when test="$first='5'">0101</xsl:when>
				<xsl:when test="$first='6'">0110</xsl:when>
				<xsl:when test="$first='7'">0111</xsl:when>
				<xsl:when test="$first='8'">1000</xsl:when>
				<xsl:when test="$first='9'">1001</xsl:when>
				<xsl:when test="$first='a'">1010</xsl:when>
				<xsl:when test="$first='b'">1011</xsl:when>
				<xsl:when test="$first='c'">1100</xsl:when>
				<xsl:when test="$first='d'">1101</xsl:when>
				<xsl:when test="$first='e'">1110</xsl:when>
				<xsl:when test="$first='f'">1111</xsl:when>
				<xsl:when test="$first='A'">1010</xsl:when>
				<xsl:when test="$first='B'">1011</xsl:when>
				<xsl:when test="$first='C'">1100</xsl:when>
				<xsl:when test="$first='D'">1101</xsl:when>
				<xsl:when test="$first='E'">1110</xsl:when>
				<xsl:when test="$first='F'">1111</xsl:when>
			</xsl:choose>
			<xsl:call-template name="hex_to_binary">
				<xsl:with-param name="hex" select="substring($hex, 2)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="add_whitespaces_to_hex_value">
  		<xsl:param name="hexValue"/>
  		<xsl:value-of select="substring($hexValue, 1, 2)"/>&#160;
  		<xsl:if test="string-length($hexValue) &gt; 3">
  			<xsl:call-template name="add_whitespaces_to_hex_value">
				<xsl:with-param name="hexValue" select="substring($hexValue, 3)" />
  			</xsl:call-template>
  		</xsl:if>
	</xsl:template>	

	<!-- divide and conquer approch to lower the recursion depth to log2 (n) [I: F-LAH_DiagProt_575] -->
	<xsl:template name="fill_coding_table">
  		<xsl:param name="left"/>
  		<xsl:param name="right"/>
  		<xsl:param name="content"/>

        <xsl:choose>
			<xsl:when test="$left = $right">
			    <xsl:variable name="bval" select="substring($content, ((($left) * 2) - 1), 2)" />
				<tr>
					<td>
						<p><xsl:value-of select="$left"/></p>
					</td>
					<td>
						<p>$<xsl:call-template name="decimal_to_hex">
								<xsl:with-param name="decimalNumber" select="$left" />
	  						</xsl:call-template></p>
					</td>
					<td>
						<p>$<xsl:value-of select="$bval" /></p>
					</td>
					<td>
						<p>
							<xsl:call-template name="hex_to_binary">
								<xsl:with-param name="hex" select="$bval" />
	  						</xsl:call-template></p>
					</td>
				</tr> 
			</xsl:when>
			<xsl:when test="$left &lt; $right">
				<xsl:variable name="middle" select="floor(($left + $right) div 2)" />
				<xsl:call-template name="fill_coding_table">
					<xsl:with-param name="left" select="$left" />
					<xsl:with-param name="right" select="$middle" />
					<xsl:with-param name="content" select="$content" />
				</xsl:call-template>
				<xsl:call-template name="fill_coding_table">
					<xsl:with-param name="left" select="$middle + 1" />
					<xsl:with-param name="right" select="$right" />
					<xsl:with-param name="content" select="$content" />
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
