<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl"/>
	<!-- *************************************************** Versionierung und Aenderungsverfolgung *****************************************************************-->
	<!-- version: $Id: 81e2e7e5b4b803ce10bb2e21b6f7f4dcf83706b5 $                                                                     -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_diagnosis" select="'1.91'"/>
	<xsl:variable name="V_Stylesheet_Datum_diagnosis" select="'13.05.2022'"/>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_sessiontime-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_diagnosis">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_diagnosis"/>
		</p>
		<p class="p_small"/>
		<!-- session time -->
		<table>
			<tr>
				<td>
					<p class="default_style_bu">
						<xsl:value-of select="$Text_session_start"/>:&#160;</p>
				</td>
				<td>
					<p>
						<xsl:call-template name="T_date_time_short">
							<xsl:with-param name="dateTime" select="date_time/moment_of_start" />
						</xsl:call-template>
					</p>
				</td>
				<td>
					<p><xsl:value-of select="$Text_session_time_spent"/>:&#160;<xsl:value-of select="floor(guided_fault_finding/diagnosis_time_spent)"/></p>
					<p><xsl:value-of select="$Text_session_time_warranty_net"/>:&#160;<xsl:value-of select="floor(guided_fault_finding/diagnosis_time_warranty)"/></p>
				</td>
			</tr>
			<tr>
				<td class="default_style_bu"><xsl:value-of select="$Text_session_stop"/>:&#160;</td>
				<td>
					<xsl:call-template name="T_date_time_short">
							<xsl:with-param name="dateTime" select="date_time/moment_of_issue" />
					</xsl:call-template>
				</td>
			</tr>	
			<tr>
				<td>
					<p class="default_style_bu">
						<xsl:value-of select="$Text_session_utc"/>:&#160;</p>
				</td>
				<td>
					<p>
					   <xsl:call-template name="T_date_time_short">
							<xsl:with-param name="dateTime" select="date_time/moment_of_start_utc" />
					   </xsl:call-template>					   
					</p>
				</td>
			</tr>
			<tr>
				<td>
					<p class="default_style_bu">
						<xsl:value-of select="$Text_session_stop_utc"/>:&#160;</p>
				</td>
				<td>
					<p>
					   <xsl:call-template name="T_date_time_short">
							<xsl:with-param name="dateTime" select="date_time/moment_of_issue_utc" />
					   </xsl:call-template>					   
					</p>
				</td>
			</tr>
		</table>

		<!-- Adds statistic data like the click count or key inputs during the diagnosis session (not for engineering). -->
		<xsl:if test="not(contains(version/Vaudas/name, 'ngineering'))">
			<br/> <!-- Zeilenumbruch -->
			<table>
				<tr>
					<td class="very_small_style">
						<xsl:value-of select="$Text_session_program_mouse_click_count"/>&#160;<xsl:value-of select="$Text_session_global_interaction"/>/<xsl:value-of select="$Text_session_start_interaction"/>/<xsl:value-of select="$Text_session_end_interaction"/>/<xsl:value-of select="$Text_session_programs_interaction"/>:&#160;<xsl:value-of select="information/interaction_statistics/session_mouse_clicks"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_entrance_mouse_clicks"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_exit_mouse_clicks"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_programs_mouse_klicks"/>&#160;
					</td>
				</tr>
				<tr>
					<td class="very_small_style">
						<xsl:value-of select="$Text_session_program_key_pressed_count"/>&#160;<xsl:value-of select="$Text_session_global_interaction"/>/<xsl:value-of select="$Text_session_start_interaction"/>/<xsl:value-of select="$Text_session_end_interaction"/>/<xsl:value-of select="$Text_session_programs_interaction"/>:&#160;<xsl:value-of select="information/interaction_statistics/session_keys_pressed"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_entrance_keys_pressed"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_exit_keys_pressed"/>&#160;/<xsl:value-of select="information/interaction_statistics/session_programs_keys_pressed"/>&#160;
					</td>
				</tr>
			</table>
		</xsl:if>
				
		<br></br>
		<table>
			<tr>
				<td>
					<p class="default_style_bu">
							<xsl:value-of select="$Text_used_gfs"/>:&#160;</p>
				</td>
			</tr>
			<tr>
			<td>
			   <p><xsl:value-of select="$Text_GFS_marque" />:&#160;</p>
			</td>
			 <td>
			   <p><xsl:value-of select="version/baseline/used_gfs_version/marque" /></p>
			</td>
			</tr>
			<tr>
			<td>
			   <p><xsl:value-of select="$Text_GFS_version" />:&#160;</p>
			</td>
			<td>
				<p><xsl:choose>
						<xsl:when test="version/baseline/used_gfs_version/marketVersion">
							<xsl:value-of select="version/baseline/used_gfs_version/marketVersion" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="version/baseline/used_gfs_version/version" />
						</xsl:otherwise>
					</xsl:choose></p>
			</td>
			</tr>
			<tr>
			<td>
			   <p><xsl:value-of select="$Text_GFS_language" />:&#160;</p>
			</td>
			 <td>
			   <p><xsl:value-of select="version/baseline/used_gfs_version/language" /></p>
			</td>
			</tr>
			<tr>
				<xsl:if test="version/baseline/used_gfs_version/marketVersion">
					<td>
						<p><xsl:value-of select="$Text_GFS_technicalVersion" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="version/baseline/used_gfs_version/version" /></p>
					</td>
				</xsl:if>
			</tr>

			<tr>
				<td>
					<p><xsl:value-of select="$Text_base_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/baseline/used_base_version/version" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_base_language" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/baseline/used_base_version/language" /></p>
				</td>
			</tr>
			<xsl:if test="version/baseline/used_dtc_exclusion">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_dtc_excl_version" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="version/baseline/used_dtc_exclusion/version" /></p>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="version/baseline/used_dtc_factors">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_dtc_factors_version" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="version/baseline/used_dtc_factors/version" /></p>
					</td>
				</tr>
			</xsl:if>

			<!-- hotfix -->
			<xsl:choose>
				<xsl:when test="version/baseline/hotfix">
					<tr>
						<td>
							<p>
								<xsl:value-of select="$Text_hotfix" />:&#160;</p>
						</td>
						<td/>
					</tr>
					<xsl:for-each select="version/baseline/hotfix">
						<tr>
							<td/>
							<td>
								<p>
									<xsl:value-of select="hotfix_name" />&#160;</p>
							</td>
						</tr>
						<tr>
							<td/>
							<td>
								<p>
									<xsl:value-of select="$Text_hotfix_loaded" />:&#160;
									<xsl:value-of select="loading_time" />&#160;</p>
							</td>
						</tr>
						<xsl:choose>
							<xsl:when test="unloading_time">
								<tr>
									<td/>
									<td>
										<p>
											<xsl:value-of select="$Text_hotfix_unloaded" />:&#160;
											<xsl:value-of select="unloading_time" />&#160;</p>
									</td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
			</xsl:choose>
		</table>

		<!-- global variables -->
		<xsl:if test="count(guided_fault_finding/diagnosis_log/global_variables/variable) > 0">
			<p class="p_small"/>
			<xsl:call-template name="func_treeView_mark_start"><xsl:with-param name="id" select="'global_variables'" /></xsl:call-template>
			<table>
				<tr>
					<td class="default_style_b">
						<xsl:call-template name="func_treeView_label">
							<xsl:with-param name="id" select="'global_variables'" />
							<xsl:with-param name="label">
								<span class="default_style_bu"><xsl:value-of select="$Text_global_variables"/>:</span>
							</xsl:with-param>
						</xsl:call-template> 
					</td>
				</tr>
			</table>
			<table class="treeView_content">
				<thead>
					<tr>
						<th>
							<p>
								<xsl:value-of select="$Text_global_variables_name"/>:</p>
						</th>
						<th>
							<p>
								<xsl:value-of select="$Text_global_variables_type"/>:</p>
						</th>
						<th>
							<p>
								<xsl:value-of select="$Text_global_variables_content"/>:</p>
						</th>
					</tr>
				</thead>
				<xsl:for-each select="guided_fault_finding/diagnosis_log/global_variables/variable">
					<tr>
						<td>
							<p>
								<xsl:value-of select="./@name"/></p>
						</td>
						<td>
							<p>
								<xsl:value-of select="./@type"/></p>
						</td>
						<td>
							<p>
								<xsl:value-of select="."/></p>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
		<!-- vin changes -->
		<xsl:if test="count(guided_fault_finding/vin_change) > 0">
			<p class="p_small"/>
			<table>
				<tr>
					<td>
						<p class="default_style_bu">
							<xsl:value-of select="$Text_vin_changes"/>:</p>
					</td>
				</tr>
			</table>
			<table>
				<tr>
					<td>
						<p>
							<xsl:value-of select="$Text_vin_changes_timestamp"/>:</p>
					</td>
					<td>
						<p>
							<xsl:value-of select="$Text_vin_changes_number"/>:</p>
					</td>
				</tr>
				<xsl:for-each select="guided_fault_finding/vin_change">
					<tr>
						<td>
							<p>
								<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./timestamp/date/day"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./timestamp/date/month"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:value-of select="./timestamp/date/year"/>&#160;<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./timestamp/time/hours"/>
									</xsl:with-param>
								</xsl:call-template>:<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./timestamp/time/minutes"/>
									</xsl:with-param>
								</xsl:call-template></p>
						</td>
						<td>
							<p>
								<xsl:value-of select="./chassis_data"/></p>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
		<!-- error log -->
		<xsl:if test="count(guided_fault_finding/error_log/error_message) > 0">
			<p class="p_small"/>
			<xsl:call-template name="func_treeView_mark_start">
				<xsl:with-param name="id" select="'error_messages_outside_GFS'"/>
			</xsl:call-template>
			<table>
				<tr>
					<td class="default_style_b">
						<xsl:call-template name="func_treeView_label">
							<xsl:with-param name="id" select="'error_messages_outside_GFS'" />
							<xsl:with-param name="label">
								<span class="default_style_bu"><xsl:value-of select="$Text_error_messages"/>:</span>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
			<div class="treeView_content">
				<xsl:for-each select="guided_fault_finding/error_log/error_message">
					<table>
						<tr>
							<td>
								<p class="default_style_b">
									<xsl:value-of select="$Text_error"/>:&#160;<xsl:value-of select="./error_id"/></p>
							</td>
						</tr>
						<tr>
							<td>
								<p style="margin-left:5mm">
									<xsl:value-of select="$Text_error_text"/>:&#160;<xsl:value-of select="./message/text"/></p>
							</td>
						</tr>
					</table>
					<!--<xsl:for-each select="message/parameters">
						<table>
							<tr>
								<td style="width:10mm">&#160;</td>
								<td style="width:155mm">
									<p class="default_style">
										<xsl:value-of select="$Text_error_parameter'"/></xsl:call-template>:&#160;&#160;<xsl:value-of select="."/>
									</p>
								</td>
							</tr>
						</table>
					</xsl:for-each>-->
				</xsl:for-each>
			</div>
			<xsl:call-template name="func_treeView_stop" />
		</xsl:if>
		<!-- diagnosis sources -->
		<p class="p_small"/>
		<xsl:call-template name="func_treeView_mark_start">
			<xsl:with-param name="id" select="'diagnosis_sources'"/>
		</xsl:call-template>
		<table>
			<tr>
				<td class="default_style_b">
					<xsl:call-template name="func_treeView_label">
						<xsl:with-param name="id" select="'diagnosis_sources'" />
						<xsl:with-param name="label">
							<span class="default_style_bu"><xsl:value-of select="$Text_dec_content"/>:</span>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<div class="treeView_content">
            <table>
               <xsl:if test="count(guided_fault_finding/diagnosis_log/BackendEcuIdentTimeStamp) > 0">
                  <tr>
                  	<td>
						<xsl:value-of select="$Text_dec_time_ident"/>
					</td><td>
						<xsl:call-template name="T_date_time">
							<xsl:with-param name="dateTime" select="guided_fault_finding/diagnosis_log/BackendEcuIdentTimeStamp"/>
						</xsl:call-template>
                  	</td>
                  </tr>
               </xsl:if>
               <xsl:if test="count(guided_fault_finding/diagnosis_log/BackendEcuFaultTimeStamp) > 0">
                  <tr>
                  	<td>
						<xsl:value-of select="$Text_dec_time_dtc"/>
					</td><td>
						<xsl:call-template name="T_date_time">
             				<xsl:with-param name="dateTime" select="guided_fault_finding/diagnosis_log/BackendEcuFaultTimeStamp"/>
						</xsl:call-template>
                  	</td>
                  </tr>
               </xsl:if>
               <xsl:if test="count(guided_fault_finding/diagnosis_log/BackendEcuIdentTimeStamp) = 0 and count(guided_fault_finding/diagnosis_log/BackendEcuFaultTimeStamp) = 0">
               	  <tr>
               	  	 <td><xsl:value-of select="$Text_dec_none"/></td>
               	  </tr>
               </xsl:if>
            </table>		    
		</div>
		<xsl:call-template name="func_treeView_stop" />
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_two_digit-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_two_digit">
		<xsl:param name="P_string"/>
		<xsl:choose>
			<xsl:when test="string-length($P_string) &gt; 1">
				<xsl:value-of select="$P_string"/>
			</xsl:when>
			<xsl:otherwise>0<xsl:value-of select="$P_string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_date_time-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_date_time">
    <xsl:param name="dateTime"/>
		<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/date/day"/>
			</xsl:with-param>
		</xsl:call-template>.<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/date/month"/>
			</xsl:with-param>
		</xsl:call-template>.<xsl:value-of select="$dateTime/date/year"/>&#160;
		<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/time/hours"/>
			</xsl:with-param>
		</xsl:call-template>:<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/time/minutes"/>
			</xsl:with-param>
		</xsl:call-template>:<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/time/seconds"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_date_time: date time format without second -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_date_time_short">
    <xsl:param name="dateTime"/>
		<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/date/day"/>
			</xsl:with-param>
		</xsl:call-template>.<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/date/month"/>
			</xsl:with-param>
		</xsl:call-template>.<xsl:value-of select="$dateTime/date/year"/>&#160;<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/time/hours"/>
			</xsl:with-param>
		</xsl:call-template>:<xsl:call-template name="T_two_digit">
			<xsl:with-param name="P_string">
				<xsl:value-of select="$dateTime/time/minutes"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
