-- Create-Script fr didb_LT3
-- Diagnoseinformations-Datenbank / Datenbankgruppe LT3 / Strukturdatenbank
--
-- Rolf Hauck / 24.04.2013 / Neu

-- zunchst alle Tabellen lschen

DROP TABLE LT3Variant                     IF EXISTS CASCADE;
DROP TABLE LT3DiagComm                    IF EXISTS CASCADE;
DROP TABLE LT3DiagRequestParam            IF EXISTS CASCADE;
DROP TABLE LT3DiagResponseParam           IF EXISTS CASCADE;
DROP TABLE LT3ParamValue                  IF EXISTS CASCADE;
DROP TABLE LT3DTC                         IF EXISTS CASCADE;
DROP TABLE LT3Unit                        IF EXISTS CASCADE;

-- alle Tabellen erzeugen, ohne Constraints oder Keys

CREATE TABLE LT3Variant
(
	VariantName       varchar(64) NOT NULL,
	BaseVariantName   varchar(64) NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3DiagComm
(
	VariantName       varchar(64) NOT NULL,
	DiagCommName      varchar(64) NOT NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3DiagRequestParam
(
	VariantName       varchar(64) NOT NULL,
	DiagCommName      varchar(64) NOT NULL,
	RequestParamName  varchar(64) NOT NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3DiagResponseParam
(
	VariantName       varchar(64) NOT NULL,
	DiagCommName      varchar(64) NOT NULL,
	ResponseParamName varchar(64) NOT NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3ParamValue
(
	VariantName       varchar(64) NOT NULL,
	DiagCommName      varchar(64) NOT NULL,
	ParamName         varchar(64) NOT NULL,
	ValueName         varchar(64) NOT NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3DTC
(
	VariantName       varchar(64) NOT NULL,
	DTC               varchar(4)  NOT NULL,
	TextId            varchar(16) NOT NULL
);

CREATE TABLE LT3Unit
(
	VariantName       varchar(64) NOT NULL,
	Unit              varchar(64) NOT NULL,
	TextId            varchar(16) NOT NULL
);

-- jetzt die Primary Keys erzeugen

ALTER TABLE LT3Variant           ADD CONSTRAINT PK_LT3Variant            PRIMARY KEY (VariantName);
ALTER TABLE LT3DiagComm          ADD CONSTRAINT PK_LT3DiagComm           PRIMARY KEY (VariantName, DiagCommName);
ALTER TABLE LT3DiagRequestParam  ADD CONSTRAINT PK_LT3DiagRequestParam   PRIMARY KEY (VariantName, DiagCommName, RequestParamName);
ALTER TABLE LT3DiagResponseParam ADD CONSTRAINT PK_LT3DiagResponseParam  PRIMARY KEY (VariantName, DiagCommName, ResponseParamName);
ALTER TABLE LT3ParamValue        ADD CONSTRAINT PK_LT3ParamValue         PRIMARY KEY (VariantName, DiagCommName, ParamName, ValueName);
ALTER TABLE LT3DTC               ADD CONSTRAINT PK_LT3DTC                PRIMARY KEY (VariantName, DTC);
ALTER TABLE LT3Unit              ADD CONSTRAINT PK_LT3Unit               PRIMARY KEY (VariantName, Unit);

-- erst nach den Primary Keys die Foreign Keys erzeugen
ALTER TABLE LT3Variant ADD CONSTRAINT FK_LT3Variant_LT3Variant
FOREIGN KEY(BaseVariantName) REFERENCES LT3Variant (VariantName) ON DELETE CASCADE;

ALTER TABLE LT3DiagComm ADD CONSTRAINT FK_LT3DiagComm_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);

ALTER TABLE LT3DiagRequestParam ADD CONSTRAINT FK_LT3DiagRequestParam_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);

ALTER TABLE LT3DiagResponseParam ADD CONSTRAINT FK_LT3DiagResponseParam_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);

ALTER TABLE LT3ParamValue ADD CONSTRAINT FK_LT3ParamValue_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);

ALTER TABLE LT3DTC ADD CONSTRAINT FK_LT3DTC_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);

ALTER TABLE LT3Unit ADD CONSTRAINT FK_LT3Unit_LT3Variant
FOREIGN KEY(VariantName) REFERENCES LT3Variant (VariantName);
