-- Create-Script f�r didb_GFS
-- Diagnoseinformations-Datenbank / Datenbankgruppe Diagnose/GFS/EFA / Strukturdatenbank
--
-- Rolf Hauck / 08.04.2010 / herausgel�st aus dem urspr�nglichen einheitlichen createTables.sql.
-- Erik Brunk / 15.04.2010 / Tabelle EquipmentTreeNode: neues Feld UMBAvailable
-- Ulrich Poppe / 16.10.2010 / Index introduced for table TestProgram, column ClassName.
-- Rolf Hauck / 04.03.2011 / Tabelle EquipmentTreeNode: neue Felder VinModelCode und VinModelYearCode (LP131)
--                           Tabellen EquipmentNode und DiagnosticObject: Jeweils Feld CreationSite entfernt (LP137)
-- J. Wrobel / 11.12.2012  / Tabellen zu EFA - DELETE CASCADE entfernt wg. incrementellen Updates (nun in Java)

-- zun�chst alle Tabellen l�schen

DROP TABLE DiagnosticObject               IF EXISTS CASCADE;
DROP TABLE DiagObjDocLink                 IF EXISTS CASCADE;
DROP TABLE DiagObjEcuReference            IF EXISTS CASCADE;
DROP TABLE DiagObjTestProg                IF EXISTS CASCADE;
DROP TABLE DocumentInheritance            IF EXISTS CASCADE;
DROP TABLE DocumentLink                   IF EXISTS CASCADE;
DROP TABLE EfaCondition                   IF EXISTS CASCADE;
DROP TABLE EfaErrorObject                 IF EXISTS CASCADE;
DROP TABLE EfaErrorObjectCondition        IF EXISTS CASCADE;
DROP TABLE EfaErrorObjectErrorType        IF EXISTS CASCADE;
DROP TABLE EfaErrorObjectLocation         IF EXISTS CASCADE;
DROP TABLE EfaErrorType                   IF EXISTS CASCADE;
DROP TABLE EfaLocation                    IF EXISTS CASCADE;
DROP TABLE EquipmentDocLink               IF EXISTS CASCADE;
DROP TABLE EquipmentEcuReference          IF EXISTS CASCADE;
DROP TABLE EquipmentTree                  IF EXISTS CASCADE;
DROP TABLE EquipmentNode                  IF EXISTS CASCADE;
DROP TABLE HotSpot                        IF EXISTS CASCADE;
DROP TABLE KnowledgeBaseTree              IF EXISTS CASCADE;
DROP TABLE MeasurementValueEcuReference   IF EXISTS CASCADE;
DROP TABLE MeasurementValueEntryKWP       IF EXISTS CASCADE;
DROP TABLE MeasurementValueEntryUDS       IF EXISTS CASCADE;
DROP TABLE MeasurementValueSuspicion      IF EXISTS CASCADE;
DROP TABLE MeasurementValueTable          IF EXISTS CASCADE;
DROP TABLE ParallelDoc                    IF EXISTS CASCADE;
DROP TABLE RequiredVersion                IF EXISTS CASCADE;
DROP TABLE StartEndModules                IF EXISTS CASCADE;
DROP TABLE Suspicion                      IF EXISTS CASCADE;
DROP TABLE TargetCurve                    IF EXISTS CASCADE;
DROP TABLE TestProgram                    IF EXISTS CASCADE;
DROP TABLE VehicleStateAttribute          IF EXISTS CASCADE;
DROP TABLE XmlTemplate                    IF EXISTS CASCADE;
DROP TABLE DocumentRepository             IF EXISTS CASCADE;
DROP TABLE DependentTestprograms          IF EXISTS CASCADE;

-- alle Tabellen erzeugen, ohne Constraints oder Keys

CREATE TABLE DiagnosticObject
(
  DiagObjectKey           varchar(64)     NOT NULL,
  DiagObjectGfsId         varchar(64)     NOT NULL,
  NameTextSource          varchar(64)         NULL,
  NameTextId              varchar(64)         NULL,
  VariantRule             varchar(65535)      NULL,
  KeepTestProgramSequence boolean         NOT NULL,
  Internal                boolean         NOT NULL,
  ExecutionMode           int             NOT NULL
);

CREATE TABLE DiagObjDocLink
(
  DiagObjectKey    varchar(64)    NOT NULL,
  DocumentLinkKey  varchar(64)    NOT NULL,
  DocCategory      int                NULL,
  VariantRule      varchar(65535)     NULL
);

CREATE TABLE DiagObjEcuReference
(
  DiagObjectKey     varchar(64)  NOT NULL,
  RefSeqNr          int          NOT NULL,
  LogicalLink       varchar(64)  NOT NULL
);

CREATE TABLE DiagObjTestProg
(
  DiagObjectKey    varchar(64)    NOT NULL,
  TestProgramKey   varchar(64)    NOT NULL,
  VariantRule      varchar(65535)     NULL,
  SporadicError    boolean        NOT NULL,
  SuccessProbability int          DEFAULT -99999 NOT NULL,
  Flags            int            DEFAULT 0 NOT NULL   -- Bit-field
);

CREATE TABLE DocumentInheritance
(
  DiagObjectKey      varchar(64)    NOT NULL,
  DocCategory        int            NOT NULL,
  Direction          int            NOT NULL, -- 1: PARENT, 2: CHILD
  VariantRule        varchar(65535)     NULL
);

CREATE TABLE DocumentLink
(
  DocumentLinkKey   varchar(64)   NOT NULL,
  VaudesObjectId    varchar(64)       NULL,
  DocNameTextSource varchar(64)       NULL,
  DocNameTextId     varchar(64)       NULL,
  DocCategory       int               NULL,
  DocFormat         int               NULL,
  SourceSystem      varchar(64)   NOT NULL,
  IdOrURI           varchar (255) NOT NULL,
  Flags            int            DEFAULT 0 NOT NULL   -- Bit-field
);

CREATE TABLE DocumentRepository
(
  DocumentLinkKey   varchar(64) NOT NULL,
  Locale            varchar(64) NOT NULL,
  Jarpath           varchar(64) NOT NULL
);

CREATE TABLE EfaCondition
(
  ConditionKey             int         NOT NULL,
  ParentConditionKey       int             NULL,
  SortOrder                int         NOT NULL,
  ConditionTitleTextSource varchar(64) NOT NULL,
  ConditionTitleTextId     varchar(64) NOT NULL
);

CREATE TABLE EfaErrorObject
(
  ErrorObjectKey             int         NOT NULL,
  ParentErrorObjectKey       int             NULL,
  ErrorObjectType            varchar(1)  NOT NULL,
  SortOrder                  int         NOT NULL,
  ErrorObjectTitleTextSource varchar(64) NOT NULL,
  ErrorObjectTitleTextId     varchar(64) NOT NULL
);

CREATE TABLE EfaErrorObjectCondition
(
  ErrorObjectKey  int   NOT NULL,
  ConditionKey    int   NOT NULL
);

CREATE TABLE EfaErrorObjectErrorType
(
  ErrorObjectKey  int   NOT NULL,
  ErrorTypeKey    int   NOT NULL
);

CREATE TABLE EfaErrorObjectLocation
(
  ErrorObjectKey  int   NOT NULL,
  LocationKey     int   NOT NULL
);

CREATE TABLE EfaErrorType
(
  ErrorTypeKey             int         NOT NULL,
  ParentErrorTypeKey       int             NULL,
  SortOrder                int         NOT NULL,
  ErrorTypeTitleTextSource varchar(64) NOT NULL,
  ErrorTypeTitleTextId     varchar(64) NOT NULL
);

CREATE TABLE EfaLocation
(
  LocationKey             int         NOT NULL,
  SortOrder               int         NOT NULL,
  LocationTitleTextSource varchar(64) NOT NULL,
  LocationTitleTextId     varchar(64) NOT NULL
);

CREATE TABLE EquipmentDocLink
(
  EquipmentNodeKey   varchar(64) NOT NULL,
  DocumentLinkKey    varchar(64) NOT NULL
);

CREATE TABLE EquipmentEcuReference
(
  EquipmentNodeKey  varchar(64)  NOT NULL,
  RefSeqNr          int          NOT NULL,
  LogicalLink       varchar(64)  NOT NULL
);

CREATE TABLE EquipmentTree
(
  ParentKey   varchar(64) NOT NULL,
  ChildSeqNr  int         NOT NULL,
  ChildKey    varchar(64) NOT NULL
);

CREATE TABLE EquipmentNode
(
  EquipmentNodeKey                  varchar(64) NOT NULL,
  EquipmentNodeGfsId                varchar(64) NOT NULL,
  NodeType                          int          NOT NULL,
  NameTextSource                    varchar(64)     NULL,
  NameTextId                        varchar(64)     NULL,
  DefinitelyPresent                 boolean          NULL,
  Brand                             varchar(64)     NULL,
  KnowledgeBaseKey                  varchar(64)     NULL,
  DiagProjectName                   varchar(64)     NULL,
  VinModelCode                      varchar(64)     NULL,
  VinModelYearCode                  varchar(2)      NULL,
  DiagObjectOnComErrorKey           varchar(64)     NULL,
  TraversionTestKey                 varchar(64)     NULL,
  MkbAvailable                      boolean          NULL,
  OBD2                              boolean          NULL,
  UseBroadcastForDTCDelete          boolean          NULL,
  WaitTimeAfterIgnition             int              NULL,
  WaitTimeAfterBroadcastDTCDelete   int              NULL,
  WaitTimeAfterDTCDelete            int              NULL,
  ReadTimeGatewayList               int              NULL,
  WaitTimeAfterGatewayCoding        int              NULL,
  CANDiagnosis                      boolean          NULL,
  AlwaysReadDTCs                    boolean          NULL,
  Diesel                            boolean          NULL,
  UMBAvailable                      boolean          NULL,
  PreSelection                      varchar(255)     NULL,
  CtySelection                      varchar(255)     NULL,
  TraversionExpression              varchar(65535)   NULL
);

CREATE TABLE HotSpot
(
  ParentDocumentLinkKey varchar(64) NOT NULL,
  HotSpotNr       int         NOT NULL,
  PosX            int         NOT NULL,
  PosY            int         NOT NULL,
  Height          int         NOT NULL,
  Width           int         NOT NULL,
  ChildDocumentLinkKey  varchar(64) NOT NULL
);

CREATE TABLE KnowledgeBaseTree
(
  ParentKey   varchar(64) NOT NULL,
  ChildSeqNr  int         NOT NULL,
  ChildKey    varchar(64) NOT NULL
);

CREATE TABLE MeasurementValueEcuReference
(
  MvTableKey        varchar(64)  NOT NULL,
  RefSeqNr          int          NOT NULL,
  LogicalLink       varchar(64)  NOT NULL
);

CREATE TABLE MeasurementValueEntryKWP
(
  MvTableKey                varchar(64)  NOT NULL,
  MvEntryId                 int          NOT NULL,
  MvGroup                   int          NOT NULL,
  MvField                   int          NOT NULL,
  MvNameTextSource          varchar(64)  NOT NULL,
  MvNameTextId              varchar(64)  NOT NULL,
  TargetValueType           int              NULL,
  TargetValue               varchar(64)      NULL,
  TargetValueMin            varchar(64)      NULL,
  TargetValueMinIncl        boolean          NULL,
  TargetValueMax            varchar(64)      NULL,
  TargetValueMaxIncl        boolean          NULL,
  TargetValueDispFormat     int              NULL,
  TargetValueTextTextSource varchar(64)      NULL,
  TargetValueTextTextId     varchar(64)      NULL,
  MvMessageTextSource       varchar(64)      NULL,
  MvMessageTextId           varchar(64)      NULL
);

CREATE TABLE MeasurementValueEntryUDS
(
  MvTableKey                varchar(64)  NOT NULL,
  MvEntryId                 int          NOT NULL,
  ShortName                 varchar(64)  NOT NULL,
  MvNameTextSource          varchar(64)  NOT NULL,
  MvNameTextId              varchar(64)  NOT NULL,
  OperationName             varchar(64)  NOT NULL,
  OperationParamName        varchar(64)      NULL,
  OperationParamValue       varchar(64)      NULL,
  ResultPath                varchar(512)     NULL,
  TargetValueType           int              NULL,
  TargetValue               varchar(64)      NULL,
  TargetValueMin            varchar(64)      NULL,
  TargetValueMinIncl        boolean          NULL,
  TargetValueMax            varchar(64)      NULL,
  TargetValueMaxIncl        boolean          NULL,
  TargetValueDispFormat     int              NULL,
  TargetValueTextTextSource varchar(64)      NULL,
  TargetValueTextTextId     varchar(64)      NULL,
  MvMessageTextSource       varchar(64)      NULL,
  MvMessageTextId           varchar(64)      NULL
);

CREATE TABLE MeasurementValueSuspicion
(
  MvTableKey                varchar(64)  NOT NULL,
  MvEntryId                 int          NOT NULL,
  SuspicionNr               int          NOT NULL,
  SuspiciousDiagObjectKey   varchar(64)  NOT NULL
);

CREATE TABLE MeasurementValueTable
(
  MvTableKey        varchar(64)  NOT NULL,
  MvTableGfsId      varchar(64)  NOT NULL,
  IsUDS             boolean      NOT NULL,
  NameTextSource    varchar(64)      NULL,
  NameTextId        varchar(64)      NULL
);

CREATE TABLE ParallelDoc
(
  ParentDocumentLinkKey varchar(64) NOT NULL,
  ChildSeqNr            int         NOT NULL,
  ChildDocumentLinkKey  varchar(64) NOT NULL
);

CREATE TABLE RequiredVersion
(
  TestProgramKey        varchar(64) NOT NULL,
  ComponentId           varchar(64) NOT NULL,
  RequiredVersion       varchar(16) NOT NULL
);

CREATE TABLE StartEndModules
(
  KnowledgeBaseKey  varchar(64)    NOT NULL,
  ModuleType        int            NOT NULL,
  ModuleSeqNr       int            NOT NULL,
  TestProgramKey    varchar(64)    NOT NULL,
  VariantRule       varchar(65535)     NULL
);

CREATE TABLE Suspicion
(
  DiagObjectKey   varchar(64)    NOT NULL,
  SuspicionNr     int            NOT NULL,
  SuspicionWeight int            NOT NULL,
  FaultExpression varchar(65535) NOT NULL
);

CREATE TABLE TargetCurve
(
  TargetCurveKey     varchar(64)  NOT NULL,
  TargetCurveGfsId   varchar(64)  NOT NULL,
  NameTextSource     varchar(64)      NULL,
  NameTextId         varchar(64)      NULL,
  Public             boolean      NOT NULL,
  Filename           varchar(255) NOT NULL,
  Jarpath            varchar(64)      NULL
);

CREATE TABLE TestProgram
(
  TestProgramKey        varchar(64)  NOT NULL,
  TestProgramGfsId      varchar(64)  NOT NULL,
  TitleTextSource       varchar(64)  NOT NULL,
  TitleTextId           varchar(64)  NOT NULL,
  DescriptionTextSource varchar(64)  NOT NULL,
  DescriptionTextId     varchar(64)  NOT NULL,
  ClassName             varchar(100) NOT NULL,
  Jarpath               varchar(64)      NULL,
  RepairLocation        int          DEFAULT 0 NOT NULL  -- 0: Werkstatt, 1: mobil, 2: remote
);

CREATE TABLE VehicleStateAttribute
(
  AttributeId       int         NOT NULL,
  AttributeValue    varchar(20) NOT NULL,
  MessageTextSource varchar(64) NOT NULL,
  MessageTextId     varchar(64) NOT NULL
);

CREATE TABLE XmlTemplate
(
  Aliasname         varchar(255) NOT NULL,
  Filename          varchar(255) NOT NULL,
  Jarpath           varchar(64)      NULL
);

-- jetzt die Primary Keys erzeugen
-- nicht alle Tabellen haben einen Primary Key

ALTER TABLE DiagnosticObject ADD CONSTRAINT PK_DiagnosticObject  PRIMARY KEY (DiagObjectKey);
-- kein PK f�r DiagObjDocLink
ALTER TABLE DiagObjEcuReference ADD CONSTRAINT PK_DiagObjEcuReference  PRIMARY KEY (DiagObjectKey, RefSeqNr);
-- kein PK f�r DiagObjTestProg
ALTER TABLE DocumentInheritance ADD CONSTRAINT PK_DocumentInheritance  PRIMARY KEY (DiagObjectKey, DocCategory);
ALTER TABLE DocumentLink ADD CONSTRAINT PK_DocumentLink  PRIMARY KEY (DocumentLinkKey);
ALTER TABLE DocumentRepository ADD CONSTRAINT PK_DocumentRepository  PRIMARY KEY (DocumentLinkKey, Locale);
ALTER TABLE EfaCondition ADD CONSTRAINT PK_EfaCondition  PRIMARY KEY (ConditionKey);
ALTER TABLE EfaErrorObject ADD CONSTRAINT PK_EfaErrorObject  PRIMARY KEY (ErrorObjectKey);
ALTER TABLE EfaErrorObjectCondition ADD CONSTRAINT PK_EfaErrorObjectCondition  PRIMARY KEY (ErrorObjectKey, ConditionKey);
ALTER TABLE EfaErrorObjectErrorType ADD CONSTRAINT PK_EfaErrorObjectErrorType  PRIMARY KEY (ErrorObjectKey, ErrorTypeKey);
ALTER TABLE EfaErrorObjectLocation ADD CONSTRAINT PK_EfaErrorObjectLocation  PRIMARY KEY (ErrorObjectKey, LocationKey);
ALTER TABLE EfaErrorType ADD CONSTRAINT PK_EfaErrorType  PRIMARY KEY (ErrorTypeKey);
ALTER TABLE EfaLocation ADD CONSTRAINT PK_EfaLocation  PRIMARY KEY (LocationKey);
-- kein PK f�r EquipmentDocLink
ALTER TABLE EquipmentEcuReference ADD CONSTRAINT PK_EquipmentEcuReference  PRIMARY KEY (EquipmentNodeKey, RefSeqNr);
ALTER TABLE EquipmentTree ADD CONSTRAINT PK_EquipmentTree  PRIMARY KEY (ParentKey, ChildSeqNr);
ALTER TABLE EquipmentNode ADD CONSTRAINT PK_EquipmentNode  PRIMARY KEY (EquipmentNodeKey);
ALTER TABLE HotSpot ADD CONSTRAINT PK_HotSpot  PRIMARY KEY (ParentDocumentLinkKey, HotSpotNr);
ALTER TABLE KnowledgeBaseTree ADD CONSTRAINT PK_KnowledgeBaseTree  PRIMARY KEY (ParentKey, ChildSeqNr);
ALTER TABLE MeasurementValueEcuReference ADD CONSTRAINT PK_MeasurementValueEcuReference  PRIMARY KEY (MvTableKey, RefSeqNr);
ALTER TABLE MeasurementValueEntryKWP ADD CONSTRAINT PK_MeasurementValueEntryKWP  PRIMARY KEY (MvTableKey, MvEntryId);
ALTER TABLE MeasurementValueEntryUDS ADD CONSTRAINT PK_MeasurementValueEntryUDS  PRIMARY KEY (MvTableKey, MvEntryId);
ALTER TABLE MeasurementValueSuspicion ADD CONSTRAINT PK_MeasurementValueSuspicion  PRIMARY KEY (MvTableKey, MvEntryId, SuspicionNr);
ALTER TABLE MeasurementValueTable ADD CONSTRAINT PK_MeasurementValueTable  PRIMARY KEY (MvTableKey);
ALTER TABLE ParallelDoc ADD CONSTRAINT PK_ParallelDoc  PRIMARY KEY (ParentDocumentLinkKey, ChildSeqNr);
ALTER TABLE RequiredVersion ADD CONSTRAINT PK_RequiredVersion PRIMARY KEY (TestProgramKey, ComponentId);
ALTER TABLE StartEndModules ADD CONSTRAINT PK_StartEndModules  PRIMARY KEY (KnowledgeBaseKey, ModuleType, ModuleSeqNr);
ALTER TABLE Suspicion ADD CONSTRAINT PK_Suspicion  PRIMARY KEY (DiagObjectKey, SuspicionNr);
ALTER TABLE TargetCurve ADD CONSTRAINT PK_TargetCurve  PRIMARY KEY (TargetCurveKey);
ALTER TABLE TestProgram ADD CONSTRAINT PK_TestProgram  PRIMARY KEY (TestProgramKey);
ALTER TABLE VehicleStateAttribute ADD CONSTRAINT PK_VehicleStateAttribute  PRIMARY KEY (AttributeId, AttributeValue);
ALTER TABLE XmlTemplate ADD CONSTRAINT PK_XmlTemplate  PRIMARY KEY (Aliasname);

-- erst nach den Primary Keys die Foreign Keys erzeugen

ALTER TABLE DiagObjDocLink ADD CONSTRAINT FK_DiagObjDocLink_DiagnosticObject
FOREIGN KEY(DiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE DiagObjDocLink ADD CONSTRAINT FK_DiagObjDocLink_DocumentLink
FOREIGN KEY(DocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE DiagObjEcuReference ADD CONSTRAINT FK_DiagObjEcuReference_DiagnosticObject
FOREIGN KEY(DiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE DiagObjTestProg ADD CONSTRAINT FK_DiagObjTestProg_DiagnosticObject
FOREIGN KEY(DiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE DiagObjTestProg ADD CONSTRAINT FK_DiagObjTestProg_TestProgram
FOREIGN KEY(TestProgramKey) REFERENCES TestProgram (TestProgramKey);

ALTER TABLE DocumentInheritance ADD CONSTRAINT FK_DocumentInheritance_DiagnosticObject
FOREIGN KEY(DiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE DocumentRepository ADD CONSTRAINT FK_DocumentRepository_DocumentLink
FOREIGN KEY(DocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE EfaCondition ADD CONSTRAINT FK_EfaCondition_EfaCondition
FOREIGN KEY(ParentConditionKey) REFERENCES EfaCondition (ConditionKey);

ALTER TABLE EfaErrorObject ADD CONSTRAINT FK_EfaErrorObject_EfaErrorObject
FOREIGN KEY(ParentErrorObjectKey) REFERENCES EfaErrorObject (ErrorObjectKey);

ALTER TABLE EfaErrorObjectCondition ADD CONSTRAINT FK_EfaErrorObjectCondition_EfaCondition
FOREIGN KEY(ConditionKey) REFERENCES EfaCondition (ConditionKey);

ALTER TABLE EfaErrorObjectCondition ADD CONSTRAINT FK_EfaErrorObjectCondition_EfaErrorObject
FOREIGN KEY(ErrorObjectKey) REFERENCES EfaErrorObject (ErrorObjectKey);

ALTER TABLE EfaErrorObjectErrorType ADD CONSTRAINT FK_EfaErrorObjectErrorType_EfaErrorType
FOREIGN KEY(ErrorTypeKey) REFERENCES EfaErrorType (ErrorTypeKey);

ALTER TABLE EfaErrorObjectErrorType ADD CONSTRAINT FK_EfaErrorObjectErrorType_EfaErrorObject
FOREIGN KEY(ErrorObjectKey) REFERENCES EfaErrorObject (ErrorObjectKey);

ALTER TABLE EfaErrorObjectLocation ADD CONSTRAINT FK_EfaErrorObjectLocation_EfaLocation
FOREIGN KEY(LocationKey) REFERENCES EfaLocation (LocationKey);

ALTER TABLE EfaErrorObjectLocation ADD CONSTRAINT FK_EfaErrorObjectLocation_EfaErrorObject
FOREIGN KEY(ErrorObjectKey) REFERENCES EfaErrorObject (ErrorObjectKey);

ALTER TABLE EfaErrorType ADD CONSTRAINT FK_EfaErrorType_EfaErrorType
FOREIGN KEY(ParentErrorTypeKey) REFERENCES EfaErrorType (ErrorTypeKey);

ALTER TABLE EquipmentDocLink ADD CONSTRAINT FK_EquipmentDocLink_DocumentLink
FOREIGN KEY(DocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE EquipmentDocLink ADD CONSTRAINT FK_EquipmentDocLink_EquipmentNode
FOREIGN KEY(EquipmentNodeKey) REFERENCES EquipmentNode (EquipmentNodeKey);

ALTER TABLE EquipmentEcuReference ADD CONSTRAINT FK_EquipmentEcuReference_EquipmentNode
FOREIGN KEY(EquipmentNodeKey) REFERENCES EquipmentNode (EquipmentNodeKey);

ALTER TABLE EquipmentTree ADD CONSTRAINT FK_EquipmentTree_Parent_EquipmentNode
FOREIGN KEY(ParentKey) REFERENCES EquipmentNode (EquipmentNodeKey);

ALTER TABLE EquipmentTree ADD CONSTRAINT FK_EquipmentTree_Child_EquipmentNode
FOREIGN KEY(ChildKey) REFERENCES EquipmentNode (EquipmentNodeKey);

ALTER TABLE EquipmentNode ADD CONSTRAINT FK_EquipmentNode_DiagnosticObject_ComError
FOREIGN KEY(DiagObjectOnComErrorKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE EquipmentNode ADD CONSTRAINT FK_EquipmentNode_DiagnosticObject_KnowledgeBase
FOREIGN KEY(KnowledgeBaseKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE EquipmentNode ADD CONSTRAINT FK_EquipmentNode_TestProgram
FOREIGN KEY(TraversionTestKey) REFERENCES TestProgram (TestProgramKey);

ALTER TABLE HotSpot ADD CONSTRAINT FK_HotSpot_Parent_DocumentLink
FOREIGN KEY(ParentDocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE HotSpot ADD CONSTRAINT FK_HotSpot_Child_DocumentLink
FOREIGN KEY(ChildDocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE KnowledgeBaseTree ADD CONSTRAINT FK_KnowledgeBaseTree_Parent_DiagnosticObject
FOREIGN KEY(ParentKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE KnowledgeBaseTree ADD CONSTRAINT FK_KnowledgeBaseTree_Child_DiagnosticObject
FOREIGN KEY(ChildKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE MeasurementValueEcuReference ADD CONSTRAINT FK_MeasurementValueEcuReference_MeasurementValueTable
FOREIGN KEY(MvTableKey) REFERENCES MeasurementValueTable (MvTableKey);

ALTER TABLE MeasurementValueEntryKWP ADD CONSTRAINT FK_MeasurementValueEntryKWP_MeasurementValueTable
FOREIGN KEY (MvTableKey) REFERENCES MeasurementValueTable (MvTableKey);

ALTER TABLE MeasurementValueEntryUDS ADD CONSTRAINT FK_MeasurementValueEntryUDS_MeasurementValueTable
FOREIGN KEY (MvTableKey) REFERENCES MeasurementValueTable (MvTableKey);

ALTER TABLE MeasurementValueSuspicion ADD CONSTRAINT FK_MeasurementValueSuspicion_MeasurementValueTable
FOREIGN KEY (MvTableKey) REFERENCES MeasurementValueTable (MvTableKey);

ALTER TABLE MeasurementValueSuspicion ADD CONSTRAINT FK_MeasurementValueSuspicion_DiagnosticObject
FOREIGN KEY (SuspiciousDiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE ParallelDoc ADD CONSTRAINT FK_ParallelDoc_Parent_DocumentLink
FOREIGN KEY(ParentDocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE ParallelDoc ADD CONSTRAINT FK_ParallelDoc_Child_DocumentLink
FOREIGN KEY(ChildDocumentLinkKey) REFERENCES DocumentLink (DocumentLinkKey);

ALTER TABLE RequiredVersion ADD CONSTRAINT FK_RequiredVersion_TestProgram
FOREIGN KEY(TestProgramKey) REFERENCES TestProgram (TestProgramKey);

ALTER TABLE StartEndModules ADD CONSTRAINT FK_StartEndModules_DiagnosticObject
FOREIGN KEY(KnowledgeBaseKey) REFERENCES DiagnosticObject (DiagObjectKey);

ALTER TABLE StartEndModules ADD CONSTRAINT FK_StartEndModules_TestProgram
FOREIGN KEY(TestProgramKey) REFERENCES TestProgram (TestProgramKey);

ALTER TABLE Suspicion ADD CONSTRAINT FK_Suspicion_DiagnosticObject
FOREIGN KEY(DiagObjectKey) REFERENCES DiagnosticObject (DiagObjectKey);

-- Additional indexes

-- special index for column ClassName of table Testprogram. Used by queries for sub test programs.
CREATE INDEX IDX_TESTPROGRAM_CLASSNAME ON TestProgram (ClassName);

-- index for searching the document links by VaudesObjectId and filename, used by importer.
CREATE INDEX IDX_DOCUMENTLINK_OID_URI ON DocumentLink (VaudesObjectId, IdOrURI);
