﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<xsl:param name="vbvFilename" />
<xsl:variable name="vbvDisplayFilename">
  <xsl:call-template name="displayFilenameWithoutPath"><xsl:with-param name="filenamewithpath"><xsl:value-of select="$vbvFilename" /></xsl:with-param></xsl:call-template>
</xsl:variable>
  
<xsl:variable name="vbvFile" select="document($vbvFilename)"/>

<xsl:variable name="ti_sg_tn">IDE00007</xsl:variable>
<xsl:variable name="ti_hw_ver">IDE00016</xsl:variable>
<xsl:variable name="ti_sw_ver">IDE00008</xsl:variable>
<xsl:variable name="ti_hw_tn">IDE00012</xsl:variable><!-- fast nie gefuellt -->
<xsl:variable name="ti_codin">IDE00003</xsl:variable><!-- fast nie gefuellt -->
<xsl:variable name="ti_sw_tn">IDExxxxx</xsl:variable><!-- TI noch nicht identifziert -->
<xsl:variable name="ti_systembez">IDE00013</xsl:variable>

<xsl:variable name="rowdetails">0</xsl:variable><!-- nur für Debug-Zwecke -->

<xsl:template match="/">
  <xsl:choose>
    <xsl:when test="$vbvFile/STEUERGERAETE_TEST"><xsl:call-template name="verbaupruefung_fs_vbv_eps201" /></xsl:when>
    <xsl:when test="$vbvFile/VBV[not(@ID)]"><xsl:call-template name="verbaupruefung_ps_vbv_eps201" /></xsl:when>
    <xsl:when test="$vbvFile/VBV[@ID]"><xsl:call-template name="verbaupruefung_vbv_idex" /></xsl:when>
    <xsl:otherwise>
      <html>
        <head>
          <title>VBV-Format nicht unterstützt</title>
          <style type="text/css">
	    .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
            .header_style_bigu {margin-top:10pt;margin-bottom:10pt;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
          </style>
        </head>
        <body class="default_style">
          <h1 class="header_style_bigu">VBV-Format nicht unterstützt</h1>
          <p>Dieser Typ von Verbauvorschriften wird derzeit für eine Verbauprüfung noch nicht unterstützt.</p>
          <p>Bisher können folgende Formate ausgewertet werden:</p>
          <ul>
            <li>Fahrzeugspezifische VBV (System42-Bezeichnung: xml-Format)</li>
            <li>Fahrzeugspezifische VBV (System42-Bezeichnung: IDEX-xml-Format)</li>
            <li>Projektspezifische VBV (eps201-Format)</li>
            <li>Projektspezifische VBV (*_susi.xml -Format)</li>
          </ul>
          <p>Nicht unterstützte Datei: <xsl:value-of select="$vbvFilename" /></p>
        </body>
      </html>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="verbaupruefung_fs_vbv_eps201">
  <html>
    <head>
	 <style type="text/css">
	  table {border-width:0;border-style=solid;border-color=black;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  tr {border-width:0;border-style=solid;border-color=black;padding:0;margin:0;text-align:left}
	  td {border-width:0;border-style=solid;border-color=black;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_error {color:red;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_unknown {color:orange;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_ok {color:green;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:10pt;margin-bottom:10pt;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
          .table_head {margin-top:12;margin-bottom:0;background-color:green;font-size:12pt;color:white;font-family:Arial;font-weight:bold;}
          .table_row0 {background-color:lightGrey;}
          .table_row1 {background-color:white;}
          .table_rowseparator {margin-top:0;margin-bottom:0;background-color:lightgrey;}
          .table_row_end {background-color:darkGreen;}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  }
	</style>

	<script language="JavaScript"><xsl:comment>
		 
	   var versionXsl = 75;


<![CDATA[ 
	   function ReadVersion(version,attentionStr,versionStr,warningStr)
	   { 
		 var versionXml = parseInt(version,10);
		 if( versionXml > versionXsl)
		 {
			document.write('<p class="p_big"></p>');
			document.write('<table><tr><td style="text-align:center;border-width=4;border-color:black;border-style:solid">');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + attentionStr + '</p>');
			document.write('<p class="default_style_big_b">' + versionStr + ':</p>');
			document.write('<p class="default_style_big_b">XSL V.' + versionXsl + ' / XML V.' + versionXml + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + warningStr + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('</td></tr></table>');
			document.write('<p class="p_big">&#160;</p>');
		}
	   }

           function popup(windowname,windowtitle,contenttext){
             var width=400;
             var height=300;
             if(window.innerWidth){
               LeftPosition =(window.innerWidth-width)/2;
               TopPosition =((window.innerHeight-height)/4)-50;
             }
             else{
               LeftPosition =(parseInt(window.screen.width)-	width)/2;
               TopPosition=((parseInt(window.screen.height)-height)/2)-50;
             }
             attr = 'resizable=yes,scrollbars=yes,width=' + width + ',height=' +
             height + ',screenX=300,screenY=200,left=' + LeftPosition + ',top=' +
             TopPosition + '';
             popWin=open('', windowname, attr);
             popWin.document.clear();
             popWin.document.writeln('<head><title>' + windowtitle + '</title>');
             popWin.document.writeln('<style type="text/css">.default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}');
	     popWin.document.writeln('.default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
	     popWin.document.writeln('.default_style_bu {margin-top:12;margin-bottom:6;font-size:12pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
             popWin.document.writeln('.default_style_bu_topmargin {margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
	     popWin.document.writeln('.default_style_ecu {background-color:#E0E0E0;margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
	     popWin.document.writeln('</style></head><body><p class="default_style_bu">' + windowtitle + '</p>');
             popWin.document.writeln(contenttext);
             popWin.document.writeln('</body></html>');
             popWin.document.close();
             popWin.focus();
             
             return false;
           }

]]>

	</xsl:comment></script>

    <title>Fahrzeugspezifische Verbauprüfung</title></head>
    <body>
      <h1 class="header_style_bigu">Fahrzeugspezifische Verbauprüfung</h1>
      <table class="default_style" cols="4" style="width=100%">
        <tr>
          <td style="width=15%" valign="top">Verbauvorschrift:</td><td style="width=35%" valign="top"><xsl:value-of select="$vbvDisplayFilename" /></td>
          <td style="width=15%" valign="top">Auslesezeitpunkt:</td><td style="width=35%" valign="top"><xsl:call-template name="display_timestamp"><xsl:with-param name="date"><xsl:value-of select="protocol/time_of_issue" /></xsl:with-param></xsl:call-template></td>
        </tr>
        <tr><td colspan="4">&#160;</td></tr>
        <tr>
          <td colspan="2" valign="top"><p class="default_style_b">Gültig für:</p></td>
          <td colspan="2" valign="top"><p class="default_style_b">Ausgewertet für:</p></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugnummer:</td><td valign="top"><xsl:value-of select="$vbvFile//FAHRZEUGNUMMER" /></td>
          <td valign="top">- Fahrzeugnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='internal_vehicle_nb']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Fahrgestellnummer:</td><td valign="top"><xsl:value-of select="$vbvFile//FAHRGESTELLNUMMER" /></td>
          <td valign="top">- Fahrgestellnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='vin']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Inventarnummer:</td><td valign="top"><xsl:value-of select="$vbvFile//INVENTARNUMMER" /></td>
          <td valign="top"></td><td></td>
        </tr>
        <tr>
          <td valign="top">- Kennzeichen:</td><td valign="top"><xsl:value-of select="$vbvFile//KENNZEICHEN" /></td>
          <td valign="top"></td><td></td>
        </tr>
        <tr>
          <td colspan="4">&#160;</td>
        </tr>
      </table>
      <table class="default_style" style="width:100%" cols="8">
        <tr class="table_head">
          <td>Adr.</td>
          <td>Systembezeichnung</td>
          <td>SG-TNR</td>
          <td>HW-TNR</td>
          <td>HW-VER</td>
          <td>SW-TNR</td>
          <td>SW-VER</td>
          <td>Status</td>
        </tr>
        <xsl:for-each select="//ecu">
          <xsl:sort select="ecu_id" />
          <xsl:for-each select="ecu_master[@type='ident']|ecu_subsystem/subsystem[@type='ident']">
            <!--<xsl:if test="not(values[ti_name='IDE00013']/display_value='NOT_AVAILABLE') and not(values[ti_name='IDE00013']/display_value='NOT_SUPPORTED')">-->
          	    <xsl:call-template name="Abgleich_SG_Teilenummer_fs_vbv_eps201" />
          	    <tr class="table_rowseparator"><td colspan="8" height="1px" ></td></tr>
			      <!--</xsl:if>-->
          </xsl:for-each>
        </xsl:for-each>
      </table>      
    </body>
  </html>
</xsl:template>


<xsl:template name="Abgleich_SG_Teilenummer_fs_vbv_eps201">
  <xsl:variable name="sg_tn"><xsl:for-each select="values[ti_name=$ti_sg_tn]/display_value"><xsl:call-template name="display_TN" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_ver"><xsl:for-each select="values[ti_name=$ti_hw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_ver"><xsl:for-each select="values[ti_name=$ti_sw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_tn"><xsl:for-each select="values[ti_name=$ti_hw_tn]/display_value"><xsl:call-template name="display_TN" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_tn"><xsl:for-each select="values[ti_name=$ti_sw_tn]/display_value"><xsl:call-template name="display_TN" /></xsl:for-each></xsl:variable>
  <xsl:variable name="codin"><xsl:for-each select="values[ti_name=$ti_codin]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="systembez">
    <xsl:value-of select="values[ti_name=$ti_systembez]/display_value" />
    <xsl:if test="ti_name='NO_ECU_COMM'"><xsl:value-of select="display_name" /></xsl:if>
  </xsl:variable>

  <xsl:variable name="rowclass">table_row1</xsl:variable>

  <xsl:variable name="reiz_adr">
    <xsl:if test="not(parent::ecu_subsystem)"><xsl:value-of select="../ecu_id" /></xsl:if>
    <xsl:if test="parent::ecu_subsystem"><xsl:text>Subsystem</xsl:text></xsl:if>
  </xsl:variable>
  <xsl:variable name="master_reiz_adr">
    <xsl:if test="parent::ecu_subsystem"><xsl:value-of select="../../ecu_id" /></xsl:if>
  </xsl:variable>

  <!-- Regeln: -->
  <!-- 1. nur eine SG-Teilenummer passt: Direkten Vergleich anstellen -->
  <!-- 2. mehrere SG-Teilenummern passen: Wenn eines dieser SGs exakt passt, alles grün, ansonsten Status falsch anmelden -->
  <!-- 3. keine SG-Teilenummer passt: Meldung SG nicht in VBV -->

  <xsl:variable name="anz_sg_tn_match">
    <xsl:value-of select="count($vbvFile//SG[@STEUERGERAET_REF=$vbvFile//STEUERGERAET[normalize-space(VW_TN)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/@ID])"/>
  </xsl:variable>

  <xsl:variable name="dtc_anzahl">
    <xsl:value-of select="count(ecu_master[@type='event_memory']/values)" />
  </xsl:variable>
 
  <!-- <xsl:variable name="dtc_anzahl">test<xsl:number count="ecu_master[@type='event_memory']/values" format="0"/></xsl:variable> -->
  <xsl:if test="$anz_sg_tn_match=0"><!-- SG nicht in Verbauvorschrift gefunden -->
    <xsl:if test="$systembez='NOT_SUPPORTED' or ($systembez='NOT_AVAILABLE')">
      <tr class="{$rowclass}">
        <td>
          <xsl:value-of select="$reiz_adr"/>
        </td>


        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
        </td>
        <td><p class="default_style"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>

      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="6">
          &#160;

        </td>
      </tr>
    </xsl:if>
    
    <xsl:if test="not ($systembez='NOT_SUPPORTED') and (not ($systembez='NOT_AVAILABLE'))">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$reiz_adr"/></td>
      
      
        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_error"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>        
        </td>
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
    
      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="6">
          <xsl:if test="not(ti_name='NO_ECU_COMM')">
            <span class="default_error">SG-Teilenummer nicht in Verbauvorschrift enthalten!</span>
          </xsl:if>
          &#160;
 
        </td>
      </tr>
    </xsl:if>
    <xsl:if test="$vbvFile//STEUERGERAET[(REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/VW_TN">
      <tr class="{$rowclass}">
        <td colspan="2"></td>
        <td colspan="6">
          <p class="default_style"><xsl:text>In VBV: </xsl:text>
            <xsl:for-each select="$vbvFile//STEUERGERAET[(REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/VW_TN">
              <xsl:value-of select="." /><xsl:if test="not(position()=last())"><xsl:text>, </xsl:text></xsl:if>
            </xsl:for-each>
          </p>
        </td>
      </tr>
    </xsl:if>
  </xsl:if>

  <xsl:variable name="verbau_ok">  
    <xsl:for-each select="$vbvFile//SG[@STEUERGERAET_REF=$vbvFile//STEUERGERAET[normalize-space(VW_TN)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/@ID]">
       <!-- kein Hardware-TNR Vergleich wird durchgeführt - HARDWARE[normalize-space(HW_TEILENUMMER)=$hw_tn -->
          <xsl:if test="HARDWARE[normalize-space(HW_STAND)=$hw_ver]">
            <xsl:if test="SOFTWARE[normalize-space(SW_TEILENUMMER)=$sw_tn]">
              <xsl:if test="SOFTWARE[normalize-space(SW_STAND)=$sw_ver]">
                <xsl:text>verbau_ok</xsl:text>
              </xsl:if>
            </xsl:if>
          </xsl:if>
    </xsl:for-each>
  </xsl:variable>
  
  <xsl:if test="$anz_sg_tn_match=1"><!-- SG taucht genau einmal in der Verbauvorschrift auf -->
    <xsl:for-each select="$vbvFile//SG[@STEUERGERAET_REF=$vbvFile//STEUERGERAET[normalize-space(VW_TN)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/@ID]">
        <tr class="{$rowclass}">
          <td><xsl:value-of select="$reiz_adr"/></td>
          <td><xsl:value-of select="$systembez" /></td>
          <td><xsl:value-of select="$sg_tn"/></td>
          <td>
            <xsl:if test="HARDWARE[normalize-space(HW_TEILENUMMER)=$hw_tn]"><p class="default_ok"><xsl:value-of select="$hw_tn"/></p></xsl:if>
            <xsl:if test="not(HARDWARE[normalize-space(HW_TEILENUMMER)=$hw_tn])"><p class="default_error"><xsl:value-of select="$hw_tn"/></p></xsl:if>
          </td>
          <td>
            <xsl:if test="HARDWARE[normalize-space(HW_STAND)=$hw_ver]"><p class="default_ok"><xsl:value-of select="$hw_ver"/></p></xsl:if>
            <xsl:if test="not(HARDWARE[normalize-space(HW_STAND)=$hw_ver])"><p class="default_error"><xsl:value-of select="$hw_ver"/></p></xsl:if>
          </td>
          <td>
            <xsl:if test="SOFTWARE[normalize-space(SW_TEILENUMMER)=$sw_tn]"><p class="default_ok"><xsl:value-of select="$sw_tn"/></p></xsl:if>
            <xsl:if test="not(SOFTWARE[normalize-space(SW_TEILENUMMER)=$sw_tn])"><p class="default_error"><xsl:value-of select="$sw_tn"/></p></xsl:if>
          </td>
          <td>
            <xsl:if test="SOFTWARE[normalize-space(SW_STAND)=$sw_ver]"><p class="default_ok"><xsl:value-of select="$sw_ver"/></p></xsl:if>
            <xsl:if test="not(SOFTWARE[normalize-space(SW_STAND)=$sw_ver])"><p class="default_error"><xsl:value-of select="$sw_ver"/></p></xsl:if>
          </td>
          <td></td>
        </tr>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="$anz_sg_tn_match>1"><!-- mehrere Einträge der VBV haben die gleiche Teilenummer wie das ausgelesene SG -->
    <xsl:if test="$verbau_ok='verbau_ok'">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$reiz_adr"/></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_ok"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
    </xsl:if>
    <xsl:if test="not($verbau_ok='verbau_ok')">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$reiz_adr"/></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
    </xsl:if>
  </xsl:if>  
          
  <xsl:if test="$rowdetails=1">
    <tr class="{$rowclass}">
      <td><xsl:value-of select="$reiz_adr"/></td>
      <td><xsl:value-of select="$systembez" /></td>
      <td><xsl:value-of select="$sg_tn"/></td>
      <td><xsl:value-of select="$hw_tn"/></td>
      <td><xsl:value-of select="$hw_ver"/></td>
      <td><xsl:value-of select="$sw_tn"/></td>
      <td><xsl:value-of select="$sw_ver"/></td>
      <td></td>
    </tr>
  </xsl:if>
  
  <xsl:for-each select="$vbvFile//SG[@STEUERGERAET_REF=$vbvFile//STEUERGERAET[normalize-space(VW_TN)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/@ID]">
    <tr class="{$rowclass}">
      <td></td>
      <td>Soll:</td>
      <td><b><xsl:value-of select="$sg_tn" /></b></td>
      <td>
        <xsl:if test="HARDWARE/HW_TEILENUMMER=$hw_tn"><b><xsl:value-of select="HARDWARE/HW_TEILENUMMER" /></b></xsl:if>
        <xsl:if test="not(HARDWARE/HW_TEILENUMMER=$hw_tn)"><xsl:value-of select="HARDWARE/HW_TEILENUMMER" /></xsl:if>
      </td>
      <td>
        <xsl:if test="HARDWARE/HW_STAND=$hw_ver"><b><xsl:value-of select="HARDWARE/HW_STAND" /></b></xsl:if>
        <xsl:if test="not(HARDWARE/HW_STAND=$hw_ver)"><xsl:value-of select="HARDWARE/HW_STAND" /></xsl:if>
      </td>
      <td>
        <xsl:if test="SOFTWARE/SW_TEILENUMMER=$sw_tn"><b><xsl:value-of select="SOFTWARE/SW_TEILENUMMER" /></b></xsl:if>
        <xsl:if test="not(SOFTWARE/SW_TEILENUMMER=$sw_tn)"><xsl:value-of select="SOFTWARE/SW_TEILENUMMER" /></xsl:if>
      </td>
      <td>
        <xsl:if test="SOFTWARE/SW_STAND=$sw_ver"><b><xsl:value-of select="SOFTWARE/SW_STAND" /></b></xsl:if>
        <xsl:if test="not(SOFTWARE/SW_STAND=$sw_ver)"><xsl:value-of select="SOFTWARE/SW_STAND" /></xsl:if>
      </td>
      <td><xsl:value-of select="$vbvFile//STEUERGERAET[normalize-space(VW_TN)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]/MUSTERSTAND" /></td>
    </tr>
    
    <xsl:if test="not(CODIERUNG='')">
      <tr class="{$rowclass}"><td></td><td></td><td colspan="6"><xsl:text>+ Kodierung IST: </xsl:text><xsl:value-of select="$codin" /></td></tr>    
      <tr class="{$rowclass}"><td></td><td></td><td colspan="6"><xsl:text>+ Kodierung SOLL: </xsl:text><xsl:value-of select="CODIERUNG" /></td></tr>
    </xsl:if>
    
    <xsl:if test="not(PARAMETRIERUNG='')">
      <tr class="{$rowclass}"><td></td><td></td><td colspan="6"><xsl:text>+ Parametrierung SOLL: </xsl:text><xsl:value-of select="PARAMETRIERUNG" /></td></tr>
    </xsl:if>

  </xsl:for-each>
</xsl:template>

<xsl:template name="verbaupruefung_ps_vbv_eps201">
  <html>
    <head>
	 <style type="text/css">
	  table {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  tr {border-width:0;padding:0;margin:0;text-align:left}
	  td {border-width:0;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_error {color:red;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_unknown {color:orange;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_ok {color:green;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:10pt;margin-bottom:10pt;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
          .table_head {background-color:green;font-size:12pt;color:white;font-family:Arial;font-weight:bold;}
          .table_row0 {background-color:lightGrey;}
          .table_row1 {background-color:white;}
          .table_rowseparator {margin-top:0;margin-bottom:0;background-color:lightgrey;}
          .table_row_end {background-color:darkGreen;}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  }
	</style>

	<script language="JavaScript"><xsl:comment>
		 
	   var versionXsl = 75;


<![CDATA[ 
	   function ReadVersion(version,attentionStr,versionStr,warningStr)
	   { 
		 var versionXml = parseInt(version,10);
		 if( versionXml > versionXsl)
		 {
			document.write('<p class="p_big"></p>');
			document.write('<table><tr><td style="text-align:center;border-width=4;border-color:black;border-style:solid">');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + attentionStr + '</p>');
			document.write('<p class="default_style_big_b">' + versionStr + ':</p>');
			document.write('<p class="default_style_big_b">XSL V.' + versionXsl + ' / XML V.' + versionXml + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + warningStr + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('</td></tr></table>');
			document.write('<p class="p_big">&#160;</p>');
		}
	   }

           function popup(windowname,windowtitle,contenttext){
             attr = 'resizable=yes,scrollbars=yes,width=640,height=480,screenX=300,screenY=200,left=100,top=100';
             popWin=open('', windowname, attr);
             popWin.document.clear();
             popWin.document.writeln('<head><title>' + windowtitle + '</title>');
             popWin.document.writeln('<style type="text/css">.default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}');
	     popWin.document.writeln('.default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
	     popWin.document.writeln('.default_style_bu {margin-top:12;margin-bottom:6;font-size:12pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
             popWin.document.writeln('.default_style_bu_topmargin {margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
	     popWin.document.writeln('.default_style_ecu {background-color:#E0E0E0;margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
             popWin.document.writeln('</style></head><body><p class="default_style_bu">' + windowtitle + '</p>');
             popWin.document.writeln(contenttext);
             popWin.document.writeln('</body></html>');
             popWin.document.close();
             popWin.focus();
             
             return false;
           }

]]>

	</xsl:comment></script>

    <title>Projektspezifische Verbauprüfung</title></head>
    <body>
      <h1 class="header_style_bigu">Projektspezifische Verbauprüfung</h1>
      <table class="default_style" cols="4" style="width=100%">
        <tr>
          <td style="width=15%" valign="top">Verbauvorschrift:</td><td style="width=35%" valign="top"><xsl:value-of select="$vbvDisplayFilename" /><br/>(EPS-201 Format)</td>
          <td style="width=15%" valign="top">Auslesezeitpunkt:</td><td style="width=35%" valign="top"><xsl:call-template name="display_timestamp"><xsl:with-param name="date"><xsl:value-of select="protocol/time_of_issue" /></xsl:with-param></xsl:call-template></td>
        </tr>
        <tr><td colspan="4">&#160;</td></tr>
        <tr>
          <td colspan="2"><p class="default_style_b">Gültig für:</p></td>
          <td colspan="2"><p class="default_style_b">Ausgewertet für:</p></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugmarke</td><td valign="top"><xsl:value-of select="$vbvFile//FAHRZEUGMARKE" /></td>
          <td valign="top">- Fahrzeugnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='internal_vehicle_nb']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugtyp:</td><td valign="top"><xsl:value-of select="$vbvFile//FAHRZEUGNAME" /><xsl:text> - </xsl:text><xsl:value-of select="$vbvFile//FZG_PLATTF" /></td>
          <td valign="top">- Fahrgestellnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='vin']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Anläufe:</td><td valign="top"><xsl:value-of select="$vbvFile//ANLAUEFE" /></td>
          <td></td><td></td>
        </tr>
        <tr>
          <td valign="top">- Bauphasen:</td><td valign="top"><xsl:value-of select="$vbvFile//BAUPHASEN" /></td>
          <td valign="top"></td><td valign="top"></td>
        </tr>
        <tr>
          <td colspan="4">&#160;</td>
        </tr>
      </table>
      
      <p class="small_style">Achtung: Die Verbauvorschrift enthält keine Freigabestatus (wie z.B. "Freigabe für KD und P" oder "gesperrt für P"). Die Interpretation der dargestellten Informationen für einen Soll-Verbau ist nur in Verbindung mit version42 möglich.</p>
      
      <table class="default_style" style="width:100%" cols="8">
        <tr class="table_head">
          <td>Adr.</td>
          <td>Systembezeichnung</td>
          <td>SG-TNR</td>
          <td>HW-TNR</td>
          <td>HW-VER</td>
          <td>SW-TNR</td>
          <td>SW-VER</td>
          <td>Bemerkung</td>
        </tr>
        <xsl:for-each select="//ecu">
          <xsl:sort select="ecu_id" />
          <xsl:for-each select="ecu_master[@type='ident']|ecu_subsystem/subsystem[@type='ident']">
          	<xsl:call-template name="Abgleich_SG_Teilenummer_ps_vbv_eps201" />
          	<tr class="table_rowseparator"><td colspan="8" height="1px" ></td></tr>
          </xsl:for-each>
        </xsl:for-each>
      </table>      
    </body>
  </html>
</xsl:template>


<xsl:template name="Abgleich_SG_Teilenummer_ps_vbv_eps201">
  <xsl:variable name="sg_tn"><xsl:for-each select="values[ti_name=$ti_sg_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_ver"><xsl:for-each select="values[ti_name=$ti_hw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_ver"><xsl:for-each select="values[ti_name=$ti_sw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_tn"><xsl:for-each select="values[ti_name=$ti_hw_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_tn"><xsl:for-each select="values[ti_name=$ti_sw_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="codin"><xsl:for-each select="values[ti_name=$ti_codin]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="systembez">
    <xsl:value-of select="values[ti_name=$ti_systembez]/display_value" />
    <xsl:if test="ti_name='NO_ECU_COMM'"><xsl:value-of select="display_name" /></xsl:if>
  </xsl:variable>

  <xsl:variable name="rowclass">table_row1</xsl:variable>

  <xsl:variable name="reiz_adr">
    <xsl:if test="not(parent::ecu_subsystem)"><xsl:value-of select="../ecu_id" /></xsl:if>
    <xsl:if test="parent::ecu_subsystem"><xsl:text>Subsystem</xsl:text></xsl:if>
  </xsl:variable>
  <xsl:variable name="master_reiz_adr">
    <xsl:if test="parent::ecu_subsystem"><xsl:value-of select="../../ecu_id" /></xsl:if>
  </xsl:variable>

  <!-- Regeln: -->
  <!-- 1. nur eine SG-Teilenummer passt: Direkten Vergleich anstellen -->
  <!-- 2. mehrere SG-Teilenummern passen: Wenn eines dieser SGs exakt passt, alles grün, ansonsten Status falsch anmelden -->
  <!-- 3. keine SG-Teilenummer passt: Meldung SG nicht in VBV -->

  <xsl:variable name="anz_sg_tn_match">
    <xsl:for-each select="$vbvFile//STEUERGERÄT[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]">
      <xsl:if test="position()=last()"><xsl:value-of select="position()" /></xsl:if>
    </xsl:for-each>
  </xsl:variable>
 
  <xsl:if test="$anz_sg_tn_match=''">
    <xsl:if test="$systembez='NOT_SUPPORTED' or ($systembez='NOT_AVAILABLE')">
      <tr class="{$rowclass}">
        <td><p class="default_style"><xsl:value-of select="$reiz_adr"/></p></td>
        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>        
        </td>
        <td><p class="default_style"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="6">
          &#160;
        </td>
      </tr>
    </xsl:if>
    
    <xsl:if test="not ($systembez='NOT_SUPPORTED') and ( not ($systembez='NOT_AVAILABLE'))">
      <tr class="{$rowclass}">
        <td>
          <p class="default_style"><xsl:value-of select="$reiz_adr"/></p>
        </td>
        
        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_error"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
        </td>
        
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="6">
          <xsl:if test="not(ti_name='NO_ECU_COMM')">
            <span class="default_error">SG-Teilenummer nicht in Verbauvorschrift enthalten!</span>
          </xsl:if>
          &#160;
        </td>
      </tr>
    </xsl:if>
  </xsl:if>

  <xsl:variable name="verbau_ok">  
    <xsl:for-each select="$vbvFile//STEUERGERÄT[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]">   
      <xsl:if test=".//HW_VERSION[normalize-space(HW_INDEX)=$hw_ver]"><!-- Kein Abgleich HW-TNR! -->
        <xsl:if test="normalize-space(SW_TEILENUMMER)=$sw_tn and .//SW_VERSION[normalize-space(SW_INDEX)=$sw_ver]">
          <xsl:text>verbau_ok</xsl:text>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>

  <xsl:if test="$anz_sg_tn_match>=1">
    <xsl:if test="$verbau_ok='verbau_ok'">
      <tr class="{$rowclass}">
        <td><p class="default_ok"><xsl:value-of select="$reiz_adr"/></p></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_ok"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
    </xsl:if>
    <xsl:if test="not($verbau_ok='verbau_ok')">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$reiz_adr"/></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
      </tr>
    </xsl:if>
  </xsl:if>  
          
  <xsl:if test="$rowdetails=1">
    <tr class="{$rowclass}">
      <td><xsl:value-of select="$reiz_adr"/></td>
      <td><xsl:value-of select="$systembez" /></td>
      <td><xsl:value-of select="$sg_tn"/></td>
      <td><xsl:value-of select="$hw_tn"/></td>
      <td><xsl:value-of select="$hw_ver"/></td>
      <td><xsl:value-of select="$sw_tn"/></td>
      <td><xsl:value-of select="$sw_ver"/></td>
      <td></td>
    </tr>
  </xsl:if>
  
  <xsl:for-each select="$vbvFile//STEUERGERÄT[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$reiz_adr or ($reiz_adr='Subsystem' and ((substring(REIZADRESSE,3,1)='#' and substring(REIZADRESSE,1,2)=$master_reiz_adr) or (not(substring(REIZADRESSE,3,1)='#') and string-length(REIZADRESSE)=3))))]">
    <xsl:if test="REIZADRESSE=$reiz_adr">
      <tr class="{$rowclass}">
        <td></td>
        <td>Soll:</td>
        <td><b><xsl:value-of select="$sg_tn" /></b></td>
        <td>
          <xsl:if test="normalize-space(HW_TEILENUMMER)=$hw_tn"><b><xsl:value-of select="HW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(HW_TEILENUMMER)=$hw_tn)"><xsl:value-of select="HW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:if test="normalize-space(HW_INDEX_SOLL)=$hw_ver"><b><xsl:value-of select="HW_INDEX_SOLL" /></b></xsl:if>
          <xsl:if test="not(normalize-space(HW_INDEX_SOLL)=$hw_ver)"><xsl:value-of select="HW_INDEX_SOLL" /></xsl:if>
          <xsl:variable name="hw_index_soll"><xsl:value-of select="HW_INDEX_SOLL" /></xsl:variable>
          <xsl:for-each select="KOMPAT_HW/HW_VERSION[not(HW_INDEX=$hw_index_soll)]/HW_INDEX">
              <xsl:if test="position()=1"> (Kompatibel: </xsl:if>
              <xsl:if test="normalize-space()=$hw_ver"><b><xsl:value-of select="." /></b></xsl:if>
              <xsl:if test="not(normalize-space()=$hw_ver)"><xsl:value-of select="." /></xsl:if>
              <xsl:if test="not(position()=last())">, </xsl:if>              
              <xsl:if test="position()=last()">)</xsl:if>
          </xsl:for-each>
        </td>
        <td>
          <xsl:if test="normalize-space(SW_TEILENUMMER)=$sw_tn"><b><xsl:value-of select="SW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(SW_TEILENUMMER)=$sw_tn)"><xsl:value-of select="SW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:if test="normalize-space(SW_INDEX_SOLL)=$sw_ver"><b><xsl:value-of select="SW_INDEX_SOLL" /></b></xsl:if>
          <xsl:if test="not(normalize-space(SW_INDEX_SOLL)=$sw_ver)"><xsl:value-of select="SW_INDEX_SOLL" /></xsl:if>
          <xsl:variable name="sw_index_soll"><xsl:value-of select="SW_INDEX_SOLL" /></xsl:variable>
          <xsl:for-each select="KOMPAT_SW/SW_VERSION[not(SW_INDEX=$sw_index_soll)]/SW_INDEX">
              <xsl:if test="position()=1"> (Kompatibel: </xsl:if>
              <xsl:if test="normalize-space(.)=$sw_ver"><b><xsl:value-of select="." /></b></xsl:if>
              <xsl:if test="not(normalize-space(.)=$sw_ver)"><xsl:value-of select="." /></xsl:if>
              <xsl:if test="not(position()=last())">, </xsl:if>              
              <xsl:if test="position()=last()">)</xsl:if>
          </xsl:for-each>
        </td>
        <td>
          <xsl:variable name="details">
            <xsl:for-each select="KOMPAT_HW/HW_VERSION">
              <![CDATA[<p class="default_style_ecu">Kompatible Hardware-Version ]]><xsl:value-of select="HW_INDEX" /><![CDATA[</p>]]>
              <xsl:call-template name="display_flashbarkeit" />
              <xsl:call-template name="display_bauphasen" />
              <xsl:call-template name="display_gueltigkeit" />
            </xsl:for-each>
            <xsl:for-each select="KOMPAT_SW/SW_VERSION">
  	      <![CDATA[<p class="default_style_ecu">Kompatible Software-Version ]]><xsl:value-of select="SW_INDEX" /><![CDATA[</p>]]>
              <xsl:call-template name="display_bauphasen" />
              <xsl:call-template name="display_gueltigkeit" />
            </xsl:for-each>
            <xsl:for-each select="VORGÄNGERLISTE/VORGÄNGER">
              <xsl:text>Vorgänger-Version  SG-TNR: </xsl:text><xsl:value-of select="SG_TEILENUMMER" />
              <xsl:text>, HW-TNR: </xsl:text><xsl:value-of select="HW_TEILENUMMER" />
              <xsl:text>, SW-TNR: </xsl:text><xsl:value-of select="SW_TEILENUMMER" />
              <![CDATA[<br>]]>
            </xsl:for-each>
            <xsl:call-template name="display_datencontainer" />
          </xsl:variable>
          <xsl:variable name="detailstitel"><xsl:text>Detailinformationen für SG-Teilenummer </xsl:text><xsl:value-of select="$sg_tn" /></xsl:variable>
          <a href="#" onclick="popup('details','{$detailstitel}','{$details}')">Details</a>
        </td>
      </tr>

      <xsl:if test="$rowdetails=1">
        <xsl:for-each select="KOMPAT_HW/HW_VERSION">
          <tr class="{$rowclass}">
            <td></td>
            <td></td>
            <td>+ Kompatible HW</td>
            <td></td>
            <td><xsl:value-of select="HW_INDEX" /></td>
            <td></td>
            <td></td>
            <td>
              <xsl:if test="not(FLASHBAR='')"><xsl:value-of select="FLASHBAR" /><xsl:text>, </xsl:text></xsl:if>
              <xsl:if test="not(BAUPHASEN='')"><xsl:value-of select="BAUPHASEN" /><xsl:text>, </xsl:text></xsl:if>
              <xsl:value-of select="GUELTIG_VON" /><xsl:text>-</xsl:text>
              <xsl:value-of select="GUELTIG_BIS" />
            </td>
          </tr>
        </xsl:for-each>
        <xsl:for-each select="KOMPAT_SW/SW_VERSION">
          <tr class="{$rowclass}">
            <td></td>
            <td></td>
            <td>+ Kompatible SW</td>
            <td></td>
            <td></td>
            <td></td>
            <td><xsl:value-of select="SW_INDEX" /></td>
            <td>
              <xsl:if test="not(BAUPHASEN='')"><xsl:value-of select="BAUPHASEN" /><xsl:text>, </xsl:text></xsl:if>
              <xsl:value-of select="GUELTIG_VON" /><xsl:text>-</xsl:text>
              <xsl:value-of select="GUELTIG_BIS" />
            </td>
          </tr>
        </xsl:for-each>
      </xsl:if>

      <xsl:for-each select="CODIERUNG">
        <xsl:if test="not(KURZ='') or not(LANG='')">
          <tr class="{$rowclass}">
            <td></td>
            <td></td>
            <td colspan="6">
              <xsl:text>+ Kodierung IST: </xsl:text><xsl:value-of select="$codin" />
            </td>
          </tr>    
          <tr class="{$rowclass}">
            <td></td>
            <td></td>
            <td colspan="6">
              <xsl:text>+ Kodierung SOLL: </xsl:text>
              <xsl:if test="not(KURZ='')"><xsl:text>Kurz: </xsl:text><xsl:value-of select="KURZ" /></xsl:if>
              <xsl:if test="not(LANG='')"><xsl:text>Lang: </xsl:text><xsl:value-of select="LANG" /></xsl:if>
            </td>
          </tr>
        </xsl:if>
      </xsl:for-each>
      
    </xsl:if>
  </xsl:for-each>
</xsl:template>


<xsl:template name="verbaupruefung_vbv_idex">
  <html>
    <head>
	 <style type="text/css">
	  table {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  tr {border-width:0;padding:0;margin:0;text-align:left}
	  td {border-width:0;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_error {color:red;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_unknown {color:orange;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_ok {color:green;margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:10pt;margin-bottom:10pt;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
          .table_head {background-color:green;font-size:12pt;color:white;font-family:Arial;font-weight:bold;}
          .table_row0 {background-color:lightGrey;}
          .table_row1 {background-color:white;}
          .table_rowseparator {margin-top:0;margin-bottom:0;background-color:lightgrey;}
          .table_row_end {background-color:darkGreen;}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  }
	</style>

	<script language="JavaScript"><xsl:comment>
		 
	   var versionXsl = 75;


<![CDATA[ 
	   function ReadVersion(version,attentionStr,versionStr,warningStr)
	   { 
		 var versionXml = parseInt(version,10);
		 if( versionXml > versionXsl)
		 {
			document.write('<p class="p_big"></p>');
			document.write('<table><tr><td style="text-align:center;border-width=4;border-color:black;border-style:solid">');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + attentionStr + '</p>');
			document.write('<p class="default_style_big_b">' + versionStr + ':</p>');
			document.write('<p class="default_style_big_b">XSL V.' + versionXsl + ' / XML V.' + versionXml + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('<p class="default_style_big_b">' + warningStr + '</p>');
			document.write('<p class="p_big">&#160;</p>');
			document.write('</td></tr></table>');
			document.write('<p class="p_big">&#160;</p>');
		}
	   }

           function popup(windowname,windowtitle,contenttext){
             attr = 'resizable=yes,scrollbars=yes,width=640,height=480,screenX=300,screenY=200,left=100,top=100';
             popWin=open('', windowname, attr);
             popWin.document.clear();
             popWin.document.writeln('<head><title>' + windowtitle + '</title>');
             popWin.document.writeln('<style type="text/css">.default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}');
	     popWin.document.writeln('.default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
	     popWin.document.writeln('.default_style_bu {margin-top:12;margin-bottom:6;font-size:12pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
             popWin.document.writeln('.default_style_bu_topmargin {margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}');
	     popWin.document.writeln('.default_style_ecu {background-color:#E0E0E0;margin-top:15;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}');
	     popWin.document.writeln('</style></head><body><p class="default_style_bu">' + windowtitle + '</p>');
             popWin.document.writeln(contenttext);
             popWin.document.writeln('</body></html>');
             popWin.document.close();
             popWin.focus();
             
             return false;
           }

]]>

	</xsl:comment></script>
      <xsl:choose>
        <xsl:when test="(($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION='')) or
                         ($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION='')))">
          <title>Fahrzeugspezifische Verbauprüfung</title>
        </xsl:when>
        <xsl:otherwise>
          <title>Projektspezifische Verbauprüfung</title>
        </xsl:otherwise>
      </xsl:choose>
    </head>
    <body>
      <xsl:choose>
        <xsl:when test="(($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION='')) or
                         ($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION='')))">
          <h1 class="header_style_bigu">Fahrzeugspezifische Verbauprüfung</h1>
        </xsl:when>
        <xsl:otherwise>
          <h1 class="header_style_bigu">Projektspezifische Verbauprüfung</h1>
        </xsl:otherwise>
      </xsl:choose>
      <table class="default_style" cols="4" style="width=100%">
        <tr>
          <td style="width=15%" valign="top">Verbauvorschrift:</td><td style="width=35%" valign="top"><xsl:value-of select="$vbvDisplayFilename" /><br/>(IDEX-Format)</td>
          <td style="width=15%" valign="top">Auslesezeitpunkt:</td><td style="width=35%" valign="top"><xsl:call-template name="display_timestamp"><xsl:with-param name="date"><xsl:value-of select="protocol/time_of_issue" /></xsl:with-param></xsl:call-template></td>
        </tr>
        <tr><td colspan="4">&#160;</td></tr>
        <tr>
          <td colspan="2"><p class="default_style_b">Gültig für:</p></td>
          <td colspan="2"><p class="default_style_b">Ausgewertet für:</p></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugmarke</td><td valign="top"><xsl:value-of select="$vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGMARKE" /></td>
          <td valign="top">- Fahrzeugnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='internal_vehicle_nb']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugtyp:</td><td valign="top"><xsl:value-of select="$vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGNAME" /><xsl:if test="not($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGNAME='') and not($vbvFile/VBV/KOPF/FAHRZEUG/FZG_PLATTF='')"><xsl:text> - </xsl:text></xsl:if><xsl:value-of select="$vbvFile/VBV/KOPF/FAHRZEUG/FZG_PLATTF" /></td>
          <td valign="top">- Fahrgestellnummer:</td><td valign="top"><xsl:value-of select="protocol/vehicle/vehicle_data[display_name='vin']/display_value" /></td>
        </tr>
        <tr>
          <td valign="top">- Fahrzeugidentifikation:</td><td valign="top"><xsl:value-of select="$vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION" /><xsl:value-of select="$vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION" /></td>
          <td valign="top"></td><td valign="top"></td>
        </tr>
        <tr>
          <td valign="top">- Anläufe:</td><td valign="top"><xsl:for-each select="$vbvFile/VBV/KOPF/ANLAEUFE/ANLAUF" ><xsl:value-of select="." /><br/></xsl:for-each></td>
          <td valign="top"></td><td valign="top"></td>
        </tr>
        <tr>
          <td valign="top">- Bauphasen:</td><td valign="top"><xsl:for-each select="$vbvFile/VBV/KOPF/BAUPHASEN/BAUPHASE" ><xsl:value-of select="." /><br/></xsl:for-each></td>
          <td valign="top"></td><td valign="top"></td>
        </tr>
        <tr>
          <td colspan="4">&#160;</td>
        </tr>
      </table>
            
      <table class="default_style" style="width:100%" cols="8">
        <tr class="table_head">
          <td>Adr.</td>
          <td>Systembezeichnung</td>
          <td>SG-TNR</td>
          <td>HW-TNR</td>
          <td>HW-VER</td>
          <td>SW-TNR</td>
          <td>SW-VER</td>
          <td>Status</td>
          <td>Bemerkung</td>
        </tr>
        <xsl:for-each select="//ecu">
          <xsl:sort select="ecu_id" />
          <xsl:for-each select="ecu_master[@type='ident']|ecu_subsystem/subsystem[@type='ident']">
          	<xsl:call-template name="Abgleich_SG_Teilenummer_IDEX" />
          	<tr class="table_rowseparator"><td colspan="9" height="1px" ></td></tr>
          </xsl:for-each>
        </xsl:for-each>
      </table>      
    </body>
  </html>
</xsl:template>

<xsl:template name="Abgleich_SG_Teilenummer_IDEX">
  <xsl:variable name="sg_tn"><xsl:for-each select="values[ti_name=$ti_sg_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_ver"><xsl:for-each select="values[ti_name=$ti_hw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_ver"><xsl:for-each select="values[ti_name=$ti_sw_ver]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="hw_tn"><xsl:for-each select="values[ti_name=$ti_hw_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="sw_tn"><xsl:for-each select="values[ti_name=$ti_sw_tn]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="codin"><xsl:for-each select="values[ti_name=$ti_codin]/display_value"><xsl:value-of select="normalize-space()" /></xsl:for-each></xsl:variable>
  <xsl:variable name="systembez">
    <xsl:value-of select="values[ti_name=$ti_systembez]/display_value" />
    <xsl:if test="ti_name='NO_ECU_COMM'"><xsl:value-of select="display_name" /></xsl:if>
  </xsl:variable>

  <xsl:variable name="rowclass">table_row1</xsl:variable>

  <xsl:variable name="diag_adr">
    <xsl:if test="not(parent::ecu_subsystem)"><xsl:value-of select="../ecu_id" /></xsl:if>
    <xsl:if test="parent::ecu_subsystem"><xsl:text>Subsystem</xsl:text></xsl:if>
  </xsl:variable>
  <xsl:variable name="master_reiz_adr">
    <xsl:if test="parent::ecu_subsystem"><xsl:value-of select="../../ecu_id" /></xsl:if>
    <xsl:if test="not(parent::ecu_subsystem)"><xsl:value-of select="../ecu_id" /></xsl:if>
  </xsl:variable>

  <!-- Regeln: -->
  <!-- 1. nur eine SG-Teilenummer passt: Direkten Vergleich anstellen -->
  <!-- 2. mehrere SG-Teilenummern passen: Wenn eines dieser SGs exakt passt, alles grün, ansonsten Status falsch anmelden -->
  <!-- 3. keine SG-Teilenummer passt: Meldung SG nicht in VBV -->

  <xsl:variable name="anz_sg_tn_match">
    <xsl:for-each select="$vbvFile//STEUERGERAET[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$diag_adr or ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(REIZADRESSE=DIAGNOSEADRESSE)))]">
      <xsl:if test="position()=last()"><xsl:value-of select="position()" /></xsl:if>
    </xsl:for-each>
  </xsl:variable>
 
  <xsl:if test="$anz_sg_tn_match=''">
    <xsl:if test="$systembez='NOT_SUPPORTED' or ($systembez='NOT_AVAILABLE')">
      <tr class="{$rowclass}">
        <td><p class="default_style"><xsl:value-of select="$diag_adr"/></p></td>
        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>        
        </td>
        <td><p class="default_style"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_style"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
        <td></td>
      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="7">
          &#160;
        </td>
      </tr>
    </xsl:if>

    <xsl:if test="not ($systembez='NOT_SUPPORTED') and (not ($systembez='NOT_AVAILABLE'))">
      <tr class="{$rowclass}">
        <td><p class="default_style"><xsl:value-of select="$diag_adr"/></p></td>
        
        <td>
          <xsl:if test="ti_name='NO_ECU_COMM'"><p class="default_error"><xsl:value-of select="$systembez" /></p></xsl:if>
          <xsl:if test="not(ti_name='NO_ECU_COMM')"><p class="default_style"><xsl:value-of select="$systembez" /></p></xsl:if>
        </td>
        
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
        <td></td>
      </tr>
      <tr class="{$rowclass}">
        <td></td>
        <td></td>
        <td colspan="7">
          <xsl:if test="not(ti_name='NO_ECU_COMM')">
            <span class="default_error">SG-Teilenummer nicht in Verbauvorschrift enthalten!</span>
          </xsl:if>
          &#160;
        </td>
      </tr>
    </xsl:if>
    
    <xsl:if test="(($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHRZEUGIDENTIFIKATION='')) or
                   ($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION and not($vbvFile/VBV/KOPF/FAHRZEUG/FAHREUGIDENTIFIKATION='')))">
      <xsl:if test="$vbvFile//STEUERGERAET[( (REIZADRESSE=$master_reiz_adr and DIAGNOSEADRESSE=$diag_adr) or 
                                             ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(DIAGNOSEADRESSE=REIZADRESSE)))]/SG_TEILENUMMER">
        <tr class="{$rowclass}">
          <td colspan="2"></td>
          <td colspan="7">
            <p class="default_style"><xsl:text>In VBV: </xsl:text>
              <xsl:for-each select="$vbvFile//STEUERGERAET[( (REIZADRESSE=$master_reiz_adr and DIAGNOSEADRESSE=$diag_adr) or 
                                             ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(DIAGNOSEADRESSE=REIZADRESSE)))]/SG_TEILENUMMER">
                <xsl:value-of select="." /><xsl:if test="not(position()=last())"><xsl:text>, </xsl:text></xsl:if>
              </xsl:for-each>
            </p>
          </td>
        </tr>
      </xsl:if>
   </xsl:if>
  </xsl:if>

  <xsl:variable name="verbau_ok">  
    <xsl:for-each select="$vbvFile//STEUERGERAET[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$diag_adr or ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(REIZADRESSE=DIAGNOSEADRESSE)))]">   
      <xsl:if test=".//HW_VERSION[normalize-space(HW_INDEX)=$hw_ver]"><!-- Kein HW-TN-Vergleich wird durchgeführt - wenn nötig integrieren: (normalize-space(HW_TEILENUMMER)=$hw_tn or @TNR_SYSTEMATIK='3') and -->
        <xsl:if test="normalize-space(SW_TEILENUMMER)=$sw_tn and .//SW_VERSION[normalize-space(SW_INDEX)=$sw_ver]">
          <xsl:text>verbau_ok</xsl:text>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>

  <xsl:if test="$anz_sg_tn_match=1">
    <xsl:for-each select="$vbvFile//STEUERGERAET[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$diag_adr or ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(REIZADRESSE=DIAGNOSEADRESSE)))]">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$diag_adr"/></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td>
          <xsl:if test="$verbau_ok='verbau_ok'"><p class="default_ok"><xsl:value-of select="$sg_tn"/></p></xsl:if>
          <xsl:if test="not($verbau_ok='verbau_ok')"><p class="default_error"><xsl:value-of select="$sg_tn"/></p></xsl:if>
        </td>
        <td>
          <xsl:if test="$verbau_ok='verbau_ok'"><p class="default_ok"><xsl:value-of select="$hw_tn"/></p></xsl:if>
          <xsl:if test="not($verbau_ok='verbau_ok')"><p class="default_error"><xsl:value-of select="$hw_tn"/></p></xsl:if>
        </td>
        <td>
          <xsl:if test="$verbau_ok='verbau_ok'"><p class="default_ok"><xsl:value-of select="$hw_ver"/></p></xsl:if>
          <xsl:if test="not($verbau_ok='verbau_ok')"><p class="default_error"><xsl:value-of select="$hw_ver"/></p></xsl:if>
        </td>
        <td>
          <xsl:if test="$verbau_ok='verbau_ok'"><p class="default_ok"><xsl:value-of select="$sw_tn"/></p></xsl:if>
          <xsl:if test="not($verbau_ok='verbau_ok')"><p class="default_error"><xsl:value-of select="$sw_tn"/></p></xsl:if>
        </td>
        <td>
          <xsl:if test="$verbau_ok='verbau_ok'"><p class="default_ok"><xsl:value-of select="$sw_ver"/></p></xsl:if>
          <xsl:if test="not($verbau_ok='verbau_ok')"><p class="default_error"><xsl:value-of select="$sw_ver"/></p></xsl:if>
        </td>
        <td></td>
        <td></td>
      </tr>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="$anz_sg_tn_match>1">
    <xsl:if test="$verbau_ok='verbau_ok'">
      <tr class="{$rowclass}">
        <td><p class="default_ok"><xsl:value-of select="$diag_adr"/></p></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_ok"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_ok"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
        <td></td>
      </tr>
    </xsl:if>
    <xsl:if test="not($verbau_ok='verbau_ok')">
      <tr class="{$rowclass}">
        <td><xsl:value-of select="$diag_adr"/></td>
        <td><xsl:value-of select="$systembez" /></td>
        <td><p class="default_error"><xsl:value-of select="$sg_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$hw_ver"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_tn"/></p></td>
        <td><p class="default_error"><xsl:value-of select="$sw_ver"/></p></td>
        <td></td>
        <td></td>
      </tr>
    </xsl:if>
  </xsl:if>  
            
  <xsl:for-each select="$vbvFile//STEUERGERAET[normalize-space(SG_TEILENUMMER)=$sg_tn and (REIZADRESSE=$diag_adr or ($diag_adr='Subsystem' and REIZADRESSE=$master_reiz_adr and not(REIZADRESSE=DIAGNOSEADRESSE)))]">
    <xsl:if test="not(.//HW_VERSION)"><!-- Sonderfall, falls keine Hardwareversion verfügbar ist -->
      <tr class="{$rowclass}">
        <td></td>
        <td>Soll:</td>
        <td><b><xsl:value-of select="$sg_tn" /></b></td>
        <td>
          <xsl:if test="normalize-space(HW_TEILENUMMER)=$hw_tn"><b><xsl:value-of select="HW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(HW_TEILENUMMER)=$hw_tn)"><xsl:value-of select="HW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:variable name="hw_index_soll"><xsl:value-of select="normalize-space(HW_INDEX_SOLL)" /></xsl:variable>
          <xsl:if test="$hw_index_soll=$hw_ver"><b><xsl:value-of select="$hw_index_soll" /></b></xsl:if>
          <xsl:if test="not($hw_index_soll=$hw_ver)"><xsl:value-of select="$hw_index_soll" /></xsl:if>
        </td>
        <td>
          <xsl:if test="normalize-space(SW_TEILENUMMER)=$sw_tn"><b><xsl:value-of select="SW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(SW_TEILENUMMER)=$sw_tn)"><xsl:value-of select="SW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:variable name="sw_index_soll"><xsl:value-of select="normalize-space(SW_INDEX_SOLL)" /></xsl:variable>
          <xsl:if test="$sw_index_soll=$sw_ver"><b><xsl:value-of select="$sw_index_soll" /></b></xsl:if>
          <xsl:if test="not($sw_index_soll=$sw_ver)"><xsl:value-of select="$sw_index_soll" /></xsl:if>
        </td>
        <td>
          <xsl:call-template name="vg_status_text"><xsl:with-param name="vg_status"><xsl:value-of select="@VG_STATUS" /></xsl:with-param></xsl:call-template>
        </td>
        <td>
          <xsl:variable name="details">
            <xsl:call-template name="display_gueltigkeit" />
            <xsl:call-template name="display_anlaeufe" />
          </xsl:variable>
          <xsl:variable name="detailstitel"><xsl:text>Detailinformationen für SG-Teilenummer </xsl:text><xsl:value-of select="$sg_tn" /></xsl:variable>
          <a href="#" onclick="popup('details','{$detailstitel}','{$details}')">Details</a>
        </td>
      </tr>
    </xsl:if>
    <xsl:for-each select=".//HW_VERSION"><!-- Standardfall: es sind kompatible Hardwareversionen verfügbar -->
      <tr class="{$rowclass}">
        <xsl:variable name="sw_index_soll"><xsl:value-of select="normalize-space(../../SW_INDEX)" /></xsl:variable>
        <td></td>
        <td>Soll:</td>
        <td><b><xsl:value-of select="$sg_tn" /></b></td>
        <td>
          <xsl:if test="normalize-space(../../../../HW_TEILENUMMER)=$hw_tn"><b><xsl:value-of select="../../../../HW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(../../../../HW_TEILENUMMER)=$hw_tn)"><xsl:value-of select="../../../../HW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:variable name="hw_index_soll"><xsl:value-of select="normalize-space(HW_INDEX)" /></xsl:variable>
          <xsl:if test="$hw_index_soll=$hw_ver"><b><xsl:value-of select="$hw_index_soll" /></b></xsl:if>
          <xsl:if test="not($hw_index_soll=$hw_ver)"><xsl:value-of select="$hw_index_soll" /></xsl:if>
        </td>
        <td>
          <xsl:if test="normalize-space(../../../../SW_TEILENUMMER)=$sw_tn"><b><xsl:value-of select="../../../../SW_TEILENUMMER" /></b></xsl:if>
          <xsl:if test="not(normalize-space(../../../../SW_TEILENUMMER)=$sw_tn)"><xsl:value-of select="../../../../SW_TEILENUMMER" /></xsl:if>
        </td>
        <td>
          <xsl:if test="$sw_index_soll=$sw_ver"><b><xsl:value-of select="$sw_index_soll" /></b></xsl:if>
          <xsl:if test="not($sw_index_soll=$sw_ver)"><xsl:value-of select="$sw_index_soll" /></xsl:if>
        </td>
        <td>
          <xsl:call-template name="vg_status_text"><xsl:with-param name="vg_status"><xsl:value-of select="@VG_STATUS" /></xsl:with-param></xsl:call-template>
        </td>
        <td>
          <xsl:variable name="details">
            <![CDATA[<br>]]>
            <xsl:for-each select="../../../../.">
              <xsl:call-template name="display_gueltigkeit" />
              <xsl:call-template name="display_anlaeufe" />
              <xsl:call-template name="display_vorgaenger" />
            </xsl:for-each>
            
	    <![CDATA[<p class="default_style_ecu">Kompatible Hardware-Version ]]><xsl:value-of select="HW_INDEX" /><![CDATA[</p>]]>
            <xsl:call-template name="display_flashbarkeit" />
            <xsl:call-template name="display_bauphasen" />
            <xsl:call-template name="display_gueltigkeit" />
            <xsl:call-template name="display_anlaeufe" />
            
            <xsl:for-each select="../../../SW_VERSION[SW_INDEX=$sw_index_soll]">
  	      <![CDATA[<p class="default_style_ecu">Kompatible Software-Version ]]><xsl:value-of select="SW_INDEX" /><![CDATA[</p>]]>
              <xsl:call-template name="display_gueltigkeit" />
              <xsl:call-template name="display_anlaeufe" />
              <xsl:call-template name="display_datencontainer" />
            </xsl:for-each>
            <xsl:call-template name="display_datencontainer" />
          </xsl:variable>
          <xsl:variable name="detailstitel"><xsl:text>Detailinformationen für SG-Teilenummer </xsl:text><xsl:value-of select="$sg_tn" /></xsl:variable>
          <a href="#" onclick="popup('details','{$detailstitel}','{$details}')">Details</a>
        </td>
      </tr>

    </xsl:for-each>
  </xsl:for-each>
</xsl:template>


<xsl:template name="display_timestamp">
  <xsl:param name="date" />
  <xsl:if test="$date!=''">
    <xsl:value-of select="substring($date,9,2)"/><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($date,6,2)"/><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($date,1,4)"/><xsl:text> </xsl:text>
    <xsl:value-of select="substring($date,12,12)"/>
  </xsl:if>  
</xsl:template>

<xsl:template name="display_TN">
    <xsl:variable name="tn"><xsl:value-of select="normalize-space()" /></xsl:variable>
    <xsl:value-of select="substring($tn,1,3)" /><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($tn,4,3)" /><xsl:text>.</xsl:text>
    <xsl:value-of select="substring($tn,7,3)" />
    <xsl:choose>
      <xsl:when test="string-length($tn)=9"></xsl:when>
      <xsl:when test="string-length($tn)=10"><xsl:text>.</xsl:text><xsl:value-of select="substring(.,10,1)" /></xsl:when>
      <xsl:otherwise><xsl:text>.</xsl:text><xsl:value-of select="substring(.,10,2)" /></xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="displayFilenameWithoutPath">
  <xsl:param name="filenamewithpath" />
  <xsl:if test="substring-after($filenamewithpath,'\')=''"><xsl:value-of select="$filenamewithpath" /></xsl:if>
  <xsl:if test="not(substring-after($filenamewithpath,'\')='')">
    <xsl:call-template name="displayFilenameWithoutPath">
      <xsl:with-param name="filenamewithpath"><xsl:value-of select="substring-after($filenamewithpath,'\')" /></xsl:with-param>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="vg_status_text">
  <xsl:param name="vg_status" />
  <xsl:choose>
    <xsl:when test="$vg_status='VG_BA'"><xsl:text>Beantragt für P und KD</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_BAV'"><xsl:text>Beantragt für Versuchsträger</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_FV'"><xsl:text>Freigabe für Versuchsträger</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_NB'"><xsl:text>Nicht bestellbar für P</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_ODX_W'"><xsl:text>ODX in Freigabe</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_OF'"><xsl:text>Offen</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_OK'"><xsl:text>Verbaufähig für P und KD</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_OKE'"><xsl:text>Eingeschränkt verbaufähig für P und KD</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_SO'"><xsl:text>nur für Sonderfall</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_VOR'"><xsl:text>In Vorbereitung</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_VT_EF'"><xsl:text>Eingeschränkte Freigabe für Versuchsträger</xsl:text></xsl:when>
    <xsl:when test="$vg_status='VG_V_SG_A'"><xsl:text>Verbundversion eingeschränkt verbaufähig für P und KD</xsl:text></xsl:when>
    <xsl:otherwise><xsl:value-of select="$vg_status" /></xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="display_gueltigkeit">
  <xsl:for-each select="GUELTIGKEITEN/GUELTIGKEIT">
    <xsl:call-template name="display_gueltigkeit" />
  </xsl:for-each>
  <xsl:if test="GUELTIG_VON and GUELTIG_BIS">
    <xsl:if test="(../GUELTIGKEIT and position()=1) or (not(../GUELTIGKEIT))"><![CDATA[<p class="default_style_bu_topmargin">]]>Gültigkeit: <![CDATA[</p>]]></xsl:if>
    <![CDATA[<p class="default_style">von: ]]>
    <xsl:if test="GUELTIG_VON='' or not(GUELTIG_VON)"><xsl:text>(undefiniert)</xsl:text></xsl:if>
    <xsl:value-of select="GUELTIG_VON" /><xsl:text> bis </xsl:text>
    <xsl:if test="GUELTIG_BIS=''  or not(GUELTIG_BIS)"><xsl:text>(undefiniert)</xsl:text></xsl:if>
    <xsl:value-of select="GUELTIG_BIS" />
    <xsl:if test="GUELTIGE_PR_NUMMER"><xsl:text> PR-Nummer: </xsl:text><xsl:value-of select="GUELTIGE_PR_NUMMER" /></xsl:if>
    <![CDATA[<br>]]>
    <xsl:if test="position()=last()"><![CDATA[</p>]]></xsl:if>
  </xsl:if>
</xsl:template>

<xsl:template name="display_anlaeufe">
  <xsl:for-each select="ANLAEUFE/ANLAUF">
    <xsl:if test="position()=1">
      <![CDATA[<p class="default_style_bu_topmargin">Anläufe: </p>]]>
      <![CDATA[<p class="default_style">]]>
    </xsl:if>
    <xsl:value-of select="." /><![CDATA[<br>]]>
    <xsl:if test="position()=last()"><![CDATA[</p>]]></xsl:if>
  </xsl:for-each>  
</xsl:template>

<xsl:template name="display_datencontainer">
  <xsl:variable name="container">
    <xsl:for-each select="DATENCONTAINER">
      <xsl:if test="*">
        <xsl:for-each select="BEZEICHNUNG"><![CDATA[<p class="default_style">]]><xsl:value-of select='.' /><![CDATA[</p>]]></xsl:for-each>
      </xsl:if>
    </xsl:for-each>
  </xsl:variable>
  <xsl:if test="not($container='')">
    <![CDATA[<p class="default_style_bu_topmargin">Datencontainer: </p>]]>
    <xsl:value-of select="$container" />
  </xsl:if>
</xsl:template>

<xsl:template name="display_flashbarkeit">
  <xsl:if test="not(FLASHBAR='') and FLASHBAR"><![CDATA[<p class="default_style_bu_topmargin">Flashbarkeit: </p><p class="default_style">]]><xsl:value-of select="FLASHBAR" /><![CDATA[</p>]]></xsl:if>
</xsl:template>

<xsl:template name="display_bauphasen">
  <xsl:for-each select="BAUPHASEN">
    <xsl:for-each select="BAUPHASE">
      <xsl:if test="position()=1">
        <![CDATA[<p class="default_style_bu_topmargin">Bauphasen: </p>]]>
        <![CDATA[<p class="default_style">]]>
      </xsl:if>
      <xsl:value-of select="." /><![CDATA[<br>]]>
      <xsl:if test="position()=last()"><![CDATA[</p>]]></xsl:if>
    </xsl:for-each>
    <xsl:if test="not(BAUPHASE) and not(.='')">
      <![CDATA[<p class="default_style_bu_topmargin">Bauphasen: </p>]]>
      <![CDATA[<p class="default_style">]]><xsl:value-of select="." /><![CDATA[</p>]]>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template name="display_vorgaenger">
  <xsl:for-each select="VORGAENGERLISTE/VORGAENGER">
    <xsl:if test="position()=1">
      <![CDATA[<p class="default_style_bu_topmargin">Vorgängerversionsliste: </p>]]>
      <![CDATA[<p class="default_style">]]>
    </xsl:if>
    <xsl:text>SG-TNR: </xsl:text><xsl:value-of select="SG_TEILENUMMER" />
    <xsl:text>, HW-TNR: </xsl:text><xsl:value-of select="HW_TEILENUMMER" />
    <xsl:text>, SW-TNR: </xsl:text><xsl:value-of select="SW_TEILENUMMER" />
    <![CDATA[<br>]]>
    <xsl:if test="position()=last()"><![CDATA[</p>]]></xsl:if>
  </xsl:for-each>
</xsl:template>
            

</xsl:stylesheet>