/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITranslatedText;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaConditionKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaErrorObjectKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaErrorTypeKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.EfaLocationKey;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaCondition;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaErrorObject;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaErrorType;
import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaLocation;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.efa.HookEfaConditionWrapper;
import de.vw.vaudes.diaghook.dto.efa.HookEfaErrorObjectWrapper;
import de.vw.vaudes.diaghook.dto.efa.HookEfaErrorTypeWrapper;
import de.vw.vaudes.diaghook.dto.efa.HookEfaLocationWrapper;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.TranslatedTextTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.EfaArtTYPE;
import de.vw.vaudes.xml.object.EfaLageTYPE;
import de.vw.vaudes.xml.object.EfaRandbedingungTYPE;
import de.vw.vaudes.xml.object.EfaStammArt;
import de.vw.vaudes.xml.object.EfaStammFehlerObjektTYPE;
import de.vw.vaudes.xml.object.EfaStammLage;
import de.vw.vaudes.xml.object.EfaStammRandbedingung;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EfaTransformHelper {
    private static final Log LOG = LogFactory.getLog(EfaTransformHelper.class);

    private EfaTransformHelper() {
    }

    public static Set<IEfaLocation> getAllEfaLocations() {
        HashSet<IEfaLocation> hashSet = new HashSet<IEfaLocation>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
        if (null != vAUDESObjekt && null == vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaLocationsFrom(vAUDESObjekt));
        } else if (null != vAUDESObjekt && null != vAUDESObjekt2) {
            List<IEfaLocation> list = EfaTransformHelper.createEfaLocationsFrom(vAUDESObjekt);
            List<IEfaLocation> list2 = EfaTransformHelper.createEfaLocationsFrom(vAUDESObjekt2);
            EfaTransformHelper.mergeEfaLocations(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt && null != vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaLocationsFrom(vAUDESObjekt2));
        }
        return hashSet;
    }

    private static List<IEfaLocation> createEfaLocationsFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IEfaLocation> arrayList = new ArrayList<IEfaLocation>();
        if (null == vAUDESObjekt.getEfaCodes()) {
            LOG.warn((Object)"Attempt to transfrom a non efa object to a efa object ... aborting");
            return arrayList;
        }
        for (EfaStammLage efaStammLage : vAUDESObjekt.getEfaCodes().getEfaStammLage()) {
            EfaLocationKey efaLocationKey = new EfaLocationKey((int)efaStammLage.getId());
            HookEfaLocationWrapper hookEfaLocationWrapper = new HookEfaLocationWrapper();
            hookEfaLocationWrapper.setLocationKey(efaLocationKey);
            hookEfaLocationWrapper.setLocationTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), efaStammLage.getStringRef()));
            hookEfaLocationWrapper.setSortOrder(efaStammLage.getReihenfolge());
            arrayList.add(hookEfaLocationWrapper);
        }
        return arrayList;
    }

    public static Set<IEfaCondition> getAllEfaConditionsForParentKey(int n) {
        HashSet<IEfaCondition> hashSet = new HashSet<IEfaCondition>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
        if (null != vAUDESObjekt && null == vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaConditionsObjectFrom(vAUDESObjekt, n));
        } else if (null != vAUDESObjekt && null != vAUDESObjekt2) {
            List<IEfaCondition> list = EfaTransformHelper.createEfaConditionsObjectFrom(vAUDESObjekt, n);
            List<IEfaCondition> list2 = EfaTransformHelper.createEfaConditionsObjectFrom(vAUDESObjekt2, n);
            EfaTransformHelper.mergeEfaConditions(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt && null != vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaConditionsObjectFrom(vAUDESObjekt2, n));
        }
        return hashSet;
    }

    private static VAUDESObjekt getEfaObjFromDbIndex() {
        VAUDESObjekt vAUDESObjekt = null;
        try {
            VAUDESObjekt vAUDESObjekt2 = DatabaseResolver.getInstance().getFromDB("EfaCodes", false);
            if (vAUDESObjekt2 instanceof VAUDESObjekt) {
                vAUDESObjekt = vAUDESObjekt2;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Error during preparation of Efa Codes from Docbase", (Throwable)exception);
        }
        return vAUDESObjekt;
    }

    private static VAUDESObjekt getEfaObjFromHookIndex() {
        VAUDESObjekt vAUDESObjekt = null;
        try {
            Object object = DiagnosticDataAccessHelper.parseFileWithoutDatabase("EfaCodes", VAUDESObjekt.class);
            if (object instanceof VAUDESObjekt) {
                vAUDESObjekt = (VAUDESObjekt)object;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Error during preparation of Efa Codes from Hook", (Throwable)exception);
        }
        return vAUDESObjekt;
    }

    private static List<IEfaCondition> createEfaConditionsObjectFrom(VAUDESObjekt vAUDESObjekt, int n) {
        ArrayList<IEfaCondition> arrayList = new ArrayList<IEfaCondition>();
        for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
            if (null == efaStammRandbedingung.getParentId() || efaStammRandbedingung.getParentId() != n) continue;
            IEfaCondition iEfaCondition = EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung);
            arrayList.add(iEfaCondition);
        }
        return arrayList;
    }

    private static IEfaCondition createEfaConditionObjectFrom(VAUDESObjekt vAUDESObjekt, EfaStammRandbedingung efaStammRandbedingung) {
        HookEfaConditionWrapper hookEfaConditionWrapper = new HookEfaConditionWrapper();
        hookEfaConditionWrapper.setConditionKey(new EfaConditionKey((int)efaStammRandbedingung.getId()));
        hookEfaConditionWrapper.setConditionTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), efaStammRandbedingung.getStringRef()));
        if (null != efaStammRandbedingung.getParentId()) {
            hookEfaConditionWrapper.setParentConditionKey(new EfaConditionKey((int)efaStammRandbedingung.getParentId().shortValue()));
        }
        hookEfaConditionWrapper.setSortOrder(efaStammRandbedingung.getReihenfolge());
        return hookEfaConditionWrapper;
    }

    public static Set<IEfaErrorObject> getAllEfaErrorObjectsForParentId(int n) {
        HashSet<IEfaErrorObject> hashSet = new HashSet<IEfaErrorObject>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
        if (null != vAUDESObjekt && null == vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaErrorObjectsFrom(vAUDESObjekt, n));
        } else if (null != vAUDESObjekt && null != vAUDESObjekt2) {
            List<IEfaErrorObject> list = EfaTransformHelper.createEfaErrorObjectsFrom(vAUDESObjekt, n);
            List<IEfaErrorObject> list2 = EfaTransformHelper.createEfaErrorObjectsFrom(vAUDESObjekt2, n);
            EfaTransformHelper.mergeEfaErrorObjects(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt && null != vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaErrorObjectsFrom(vAUDESObjekt2, n));
        }
        return hashSet;
    }

    private static List<IEfaErrorObject> createEfaErrorObjectsFrom(VAUDESObjekt vAUDESObjekt, int n) {
        ArrayList<IEfaErrorObject> arrayList = new ArrayList<IEfaErrorObject>();
        for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
            if (null == efaStammFehlerObjektTYPE.getParentId() || efaStammFehlerObjektTYPE.getParentId() != n) continue;
            IEfaErrorObject iEfaErrorObject = EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt, efaStammFehlerObjektTYPE);
            arrayList.add(iEfaErrorObject);
        }
        return arrayList;
    }

    private static IEfaErrorObject createEfaErrorObjectFrom(VAUDESObjekt vAUDESObjekt, EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE) {
        HookEfaErrorObjectWrapper hookEfaErrorObjectWrapper = new HookEfaErrorObjectWrapper();
        hookEfaErrorObjectWrapper.setErrorObjectKey(new EfaErrorObjectKey(efaStammFehlerObjektTYPE.getId()));
        hookEfaErrorObjectWrapper.setErrorObjectTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), efaStammFehlerObjektTYPE.getStringRef()));
        hookEfaErrorObjectWrapper.setErrorObjectType(EfaTransformHelper.transformErrorType(efaStammFehlerObjektTYPE.getObjektType()));
        hookEfaErrorObjectWrapper.setSortOrder(efaStammFehlerObjektTYPE.getReihenfolge());
        if (null != efaStammFehlerObjektTYPE.getParentId()) {
            hookEfaErrorObjectWrapper.setParentErrorObjectKey(new EfaErrorObjectKey(efaStammFehlerObjektTYPE.getParentId().intValue()));
        }
        return hookEfaErrorObjectWrapper;
    }

    private static IEfaErrorObject.IObjectType transformErrorType(String string) {
        IEfaErrorObject.IObjectType iObjectType = IEfaErrorObject.IObjectType.UNDEFINED;
        if (string.equalsIgnoreCase("h")) {
            iObjectType = IEfaErrorObject.IObjectType.MAINGROUP;
        } else if (string.equalsIgnoreCase("b")) {
            iObjectType = IEfaErrorObject.IObjectType.COMPONENT;
        } else if (string.equalsIgnoreCase("f")) {
            iObjectType = IEfaErrorObject.IObjectType.FUNCTION;
        }
        return iObjectType;
    }

    public static Set<IEfaErrorType> getEfaErrorTypesForEfaErrorTypeParentId(int n) {
        HashSet<IEfaErrorType> hashSet = new HashSet<IEfaErrorType>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
        if (null != vAUDESObjekt && null == vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaErrorTypesFrom(vAUDESObjekt, n));
        } else if (null != vAUDESObjekt && null != vAUDESObjekt2) {
            List<IEfaErrorType> list = EfaTransformHelper.createEfaErrorTypesFrom(vAUDESObjekt, n);
            List<IEfaErrorType> list2 = EfaTransformHelper.createEfaErrorTypesFrom(vAUDESObjekt2, n);
            EfaTransformHelper.mergeEfaTypes(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt && null != vAUDESObjekt2) {
            hashSet.addAll(EfaTransformHelper.createEfaErrorTypesFrom(vAUDESObjekt2, n));
        }
        return hashSet;
    }

    private static List<IEfaErrorType> createEfaErrorTypesFrom(VAUDESObjekt vAUDESObjekt, int n) {
        ArrayList<IEfaErrorType> arrayList = new ArrayList<IEfaErrorType>();
        for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
            if (null == efaStammArt.getParentId() || efaStammArt.getParentId() != n) continue;
            IEfaErrorType iEfaErrorType = EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt);
            iEfaErrorType.setParentErrorTypeKey(new EfaErrorTypeKey(n));
            arrayList.add(iEfaErrorType);
        }
        return arrayList;
    }

    private static IEfaErrorType createEfaErrorTypeFrom(VAUDESObjekt vAUDESObjekt, EfaStammArt efaStammArt) {
        HookEfaErrorTypeWrapper hookEfaErrorTypeWrapper = new HookEfaErrorTypeWrapper();
        hookEfaErrorTypeWrapper.setErrorTypeKey(new EfaErrorTypeKey((int)efaStammArt.getId()));
        if (null != efaStammArt.getParentId()) {
            hookEfaErrorTypeWrapper.setParentErrorTypeKey(new EfaErrorTypeKey((int)efaStammArt.getParentId().shortValue()));
        }
        hookEfaErrorTypeWrapper.setErrorTypeTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), efaStammArt.getStringRef()));
        hookEfaErrorTypeWrapper.setSortOrder(efaStammArt.getReihenfolge());
        return hookEfaErrorTypeWrapper;
    }

    public static IEfaCondition getEfaConditionForId(int n) {
        IEfaCondition iEfaCondition;
        block8: {
            iEfaCondition = null;
            VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
            VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
            try {
                if (null != vAUDESObjekt && null == vAUDESObjekt2) {
                    for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
                        if (efaStammRandbedingung.getId() != n) continue;
                        iEfaCondition = EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt && null != vAUDESObjekt2) {
                    for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
                        if (efaStammRandbedingung.getId() != n) continue;
                        iEfaCondition = EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung);
                        break;
                    }
                    if (iEfaCondition != null) break block8;
                    for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt2.getEfaCodes().getEfaStammRandbedingung()) {
                        if (efaStammRandbedingung.getId() != n) continue;
                        iEfaCondition = EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt2, efaStammRandbedingung);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt || null == vAUDESObjekt2) break block8;
                for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt2.getEfaCodes().getEfaStammRandbedingung()) {
                    if (efaStammRandbedingung.getId() != n) continue;
                    iEfaCondition = EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt2, efaStammRandbedingung);
                    break;
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error while creating efa object ", (Throwable)exception);
            }
        }
        return iEfaCondition;
    }

    public static IEfaErrorObject getEfaErrorObjectForId(int n) {
        IEfaErrorObject iEfaErrorObject;
        block8: {
            iEfaErrorObject = null;
            VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
            VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
            try {
                if (null != vAUDESObjekt && null == vAUDESObjekt2) {
                    for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                        if (efaStammFehlerObjektTYPE.getId() != n) continue;
                        iEfaErrorObject = EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt, efaStammFehlerObjektTYPE);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt && null != vAUDESObjekt2) {
                    for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                        if (efaStammFehlerObjektTYPE.getId() != n) continue;
                        iEfaErrorObject = EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt, efaStammFehlerObjektTYPE);
                        break;
                    }
                    if (iEfaErrorObject != null) break block8;
                    for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt2.getEfaCodes().getEfaStammFehlerObjekt()) {
                        if (efaStammFehlerObjektTYPE.getId() != n) continue;
                        iEfaErrorObject = EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt2, efaStammFehlerObjektTYPE);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt || null == vAUDESObjekt2) break block8;
                for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt2.getEfaCodes().getEfaStammFehlerObjekt()) {
                    if (efaStammFehlerObjektTYPE.getId() != n) continue;
                    iEfaErrorObject = EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt2, efaStammFehlerObjektTYPE);
                    break;
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error while creating efa object ", (Throwable)exception);
            }
        }
        return iEfaErrorObject;
    }

    public static void adjustEfaCondition(IEfaCondition iEfaCondition, IEfaCondition iEfaCondition2) {
        iEfaCondition.setConditionKey(iEfaCondition2.getConditionKey());
        iEfaCondition.setConditionTitle(iEfaCondition2.getConditionTitle());
        iEfaCondition.setParentConditionKey(iEfaCondition2.getParentConditionKey());
        iEfaCondition.setSortOrder(iEfaCondition2.getSortOrder());
    }

    public static void adjustEfaErrorObject(IEfaErrorObject iEfaErrorObject, IEfaErrorObject iEfaErrorObject2) {
        iEfaErrorObject.setErrorObjectKey(iEfaErrorObject2.getErrorObjectKey());
        iEfaErrorObject.setErrorObjectTitle(iEfaErrorObject2.getErrorObjectTitle());
        iEfaErrorObject.setErrorObjectType(iEfaErrorObject2.getErrorObjectType());
        iEfaErrorObject.setParentErrorObjectKey(iEfaErrorObject2.getParentErrorObjectKey());
        iEfaErrorObject.setSortOrder(iEfaErrorObject2.getSortOrder());
    }

    public static IEfaErrorType getEfaErrorTypeForId(int n) {
        IEfaErrorType iEfaErrorType;
        block8: {
            iEfaErrorType = null;
            VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
            VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
            try {
                if (null != vAUDESObjekt && null == vAUDESObjekt2) {
                    for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
                        if (efaStammArt.getId() != n) continue;
                        iEfaErrorType = EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt && null != vAUDESObjekt2) {
                    for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
                        if (efaStammArt.getId() != n) continue;
                        iEfaErrorType = EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt);
                        break;
                    }
                    if (null != iEfaErrorType) break block8;
                    for (EfaStammArt efaStammArt : vAUDESObjekt2.getEfaCodes().getEfaStammArt()) {
                        if (efaStammArt.getId() != n) continue;
                        iEfaErrorType = EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt2, efaStammArt);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt || null == vAUDESObjekt2) break block8;
                for (EfaStammArt efaStammArt : vAUDESObjekt2.getEfaCodes().getEfaStammArt()) {
                    if (efaStammArt.getId() != n) continue;
                    iEfaErrorType = EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt2, efaStammArt);
                    break;
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error while creating efa object ", (Throwable)exception);
            }
        }
        return iEfaErrorType;
    }

    public static void adjustEfaErrorType(IEfaErrorType iEfaErrorType, IEfaErrorType iEfaErrorType2) {
        iEfaErrorType.setErrorTypeKey(iEfaErrorType2.getErrorTypeKey());
        iEfaErrorType.setErrorTypeTitle(iEfaErrorType2.getErrorTypeTitle());
        iEfaErrorType.setParentErrorTypeKey(iEfaErrorType2.getParentErrorTypeKey());
        iEfaErrorType.setSortOrder(iEfaErrorType2.getSortOrder());
    }

    public static IEfaLocation getEfaLocationForId(int n) {
        IEfaLocation iEfaLocation;
        block8: {
            iEfaLocation = null;
            VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
            VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
            try {
                if (null != vAUDESObjekt && null == vAUDESObjekt2) {
                    for (EfaStammLage efaStammLage : vAUDESObjekt.getEfaCodes().getEfaStammLage()) {
                        if (efaStammLage.getId() != n) continue;
                        iEfaLocation = EfaTransformHelper.createEfaLocation(vAUDESObjekt, efaStammLage);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt && null != vAUDESObjekt2) {
                    for (EfaStammLage efaStammLage : vAUDESObjekt.getEfaCodes().getEfaStammLage()) {
                        if (efaStammLage.getId() != n) continue;
                        iEfaLocation = EfaTransformHelper.createEfaLocation(vAUDESObjekt, efaStammLage);
                        break;
                    }
                    if (null != iEfaLocation) break block8;
                    for (EfaStammLage efaStammLage : vAUDESObjekt2.getEfaCodes().getEfaStammLage()) {
                        if (efaStammLage.getId() != n) continue;
                        iEfaLocation = EfaTransformHelper.createEfaLocation(vAUDESObjekt2, efaStammLage);
                        break block8;
                    }
                    break block8;
                }
                if (null != vAUDESObjekt || null == vAUDESObjekt2) break block8;
                for (EfaStammLage efaStammLage : vAUDESObjekt2.getEfaCodes().getEfaStammLage()) {
                    if (efaStammLage.getId() != n) continue;
                    iEfaLocation = EfaTransformHelper.createEfaLocation(vAUDESObjekt2, efaStammLage);
                    break;
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error while creating efa object ", (Throwable)exception);
            }
        }
        return iEfaLocation;
    }

    private static IEfaLocation createEfaLocation(VAUDESObjekt vAUDESObjekt, EfaStammLage efaStammLage) {
        HookEfaLocationWrapper hookEfaLocationWrapper = new HookEfaLocationWrapper();
        EfaLocationKey efaLocationKey = new EfaLocationKey((int)efaStammLage.getId());
        hookEfaLocationWrapper.setLocationKey(efaLocationKey);
        hookEfaLocationWrapper.setLocationTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), efaStammLage.getStringRef()));
        hookEfaLocationWrapper.setSortOrder(efaStammLage.getReihenfolge());
        return hookEfaLocationWrapper;
    }

    public static void adjustEfaLocation(IEfaLocation iEfaLocation, IEfaLocation iEfaLocation2) {
        iEfaLocation.setLocationKey(iEfaLocation2.getLocationKey());
        iEfaLocation.setLocationTitle(iEfaLocation2.getLocationTitle());
        iEfaLocation.setSortOrder(iEfaLocation2.getSortOrder());
    }

    public static Set<IEfaErrorType> getAllEfaErrorTypesForEfaErrorId(int n) {
        HashSet<IEfaErrorType> hashSet = new HashSet<IEfaErrorType>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromDbIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromHookIndex();
        ArrayList<VAUDESObjekt> arrayList = new ArrayList<VAUDESObjekt>();
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
            arrayList.add(vAUDESObjekt);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt);
        }
        HashSet<Short> hashSet2 = new HashSet<Short>();
        hashSet2.addAll(EfaTransformHelper.collectEfaErrorTypeIdsForEfaErrorParentId(n, arrayList));
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaErrorTypesForIds(hashSet2, vAUDESObjekt2));
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            List<IEfaErrorType> list = EfaTransformHelper.getEfaErrorTypesForIds(hashSet2, vAUDESObjekt2);
            List<IEfaErrorType> list2 = EfaTransformHelper.getEfaErrorTypesForIds(hashSet2, vAUDESObjekt);
            EfaTransformHelper.mergeEfaTypes(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaErrorTypesForIds(hashSet2, vAUDESObjekt));
        }
        return hashSet;
    }

    private static List<IEfaErrorType> getEfaErrorTypesForIds(Set<Short> set, VAUDESObjekt vAUDESObjekt) {
        ArrayList<IEfaErrorType> arrayList = new ArrayList<IEfaErrorType>();
        for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
            if (!set.contains(efaStammArt.getId())) continue;
            arrayList.add(EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt));
        }
        return arrayList;
    }

    private static Set<Short> collectEfaErrorTypeIdsForEfaErrorParentId(int n, List<VAUDESObjekt> list) {
        HashSet<Short> hashSet = new HashSet<Short>();
        for (VAUDESObjekt vAUDESObjekt : list) {
            for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                if (efaStammFehlerObjektTYPE.getId() != n || null == efaStammFehlerObjektTYPE.getEfaArten()) continue;
                for (EfaArtTYPE efaArtTYPE : efaStammFehlerObjektTYPE.getEfaArten().getEfaArt()) {
                    hashSet.add(efaArtTYPE.getId());
                }
            }
        }
        return hashSet;
    }

    public static Set<IEfaCondition> getEfaConditionsForEfaErrorObjectId(int n) {
        HashSet<IEfaCondition> hashSet = new HashSet<IEfaCondition>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromDbIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromHookIndex();
        ArrayList<VAUDESObjekt> arrayList = new ArrayList<VAUDESObjekt>();
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
            arrayList.add(vAUDESObjekt);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt);
        }
        HashSet<Short> hashSet2 = new HashSet<Short>();
        hashSet2.addAll(EfaTransformHelper.collectEfaConditionIdsForEfaErrorObjectParentId(n, arrayList));
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaConditionsForIds(hashSet2, vAUDESObjekt2));
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            List<IEfaCondition> list = EfaTransformHelper.getEfaConditionsForIds(hashSet2, vAUDESObjekt2);
            List<IEfaCondition> list2 = EfaTransformHelper.getEfaConditionsForIds(hashSet2, vAUDESObjekt);
            EfaTransformHelper.mergeEfaConditions(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaConditionsForIds(hashSet2, vAUDESObjekt));
        }
        return hashSet;
    }

    private static List<IEfaCondition> getEfaConditionsForIds(Set<Short> set, VAUDESObjekt vAUDESObjekt) {
        ArrayList<IEfaCondition> arrayList = new ArrayList<IEfaCondition>();
        for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
            if (!set.contains(efaStammRandbedingung.getId())) continue;
            arrayList.add(EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung));
        }
        return arrayList;
    }

    private static Set<Short> collectEfaConditionIdsForEfaErrorObjectParentId(int n, List<VAUDESObjekt> list) {
        HashSet<Short> hashSet = new HashSet<Short>();
        for (VAUDESObjekt vAUDESObjekt : list) {
            for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                if (efaStammFehlerObjektTYPE.getId() != n || null == efaStammFehlerObjektTYPE.getEfaRandbedingungen()) continue;
                for (EfaRandbedingungTYPE efaRandbedingungTYPE : efaStammFehlerObjektTYPE.getEfaRandbedingungen().getEfaRandbedingung()) {
                    hashSet.add(efaRandbedingungTYPE.getId());
                }
            }
        }
        return hashSet;
    }

    public static Set<IEfaLocation> getEfaLocationsForEfaErrorObjectId(int n) {
        HashSet<IEfaLocation> hashSet = new HashSet<IEfaLocation>();
        VAUDESObjekt vAUDESObjekt = EfaTransformHelper.getEfaObjFromDbIndex();
        VAUDESObjekt vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromHookIndex();
        ArrayList<VAUDESObjekt> arrayList = new ArrayList<VAUDESObjekt>();
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt2);
            arrayList.add(vAUDESObjekt);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            arrayList.add(vAUDESObjekt);
        }
        HashSet<Short> hashSet2 = new HashSet<Short>();
        hashSet2.addAll(EfaTransformHelper.collectEfaLocationIdsForEfaErrorObjectParentId(n, arrayList));
        if (null != vAUDESObjekt2 && null == vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaLocationsForIds(hashSet2, vAUDESObjekt2));
        } else if (null != vAUDESObjekt2 && null != vAUDESObjekt) {
            List<IEfaLocation> list = EfaTransformHelper.getEfaLocationsForIds(hashSet2, vAUDESObjekt2);
            List<IEfaLocation> list2 = EfaTransformHelper.getEfaLocationsForIds(hashSet2, vAUDESObjekt);
            EfaTransformHelper.mergeEfaLocations(list2, list);
            hashSet.addAll(list2);
        } else if (null == vAUDESObjekt2 && null != vAUDESObjekt) {
            hashSet.addAll(EfaTransformHelper.getEfaLocationsForIds(hashSet2, vAUDESObjekt));
        }
        return hashSet;
    }

    private static List<IEfaLocation> getEfaLocationsForIds(Set<Short> set, VAUDESObjekt vAUDESObjekt) {
        ArrayList<IEfaLocation> arrayList = new ArrayList<IEfaLocation>();
        for (EfaStammLage efaStammLage : vAUDESObjekt.getEfaCodes().getEfaStammLage()) {
            if (!set.contains(efaStammLage.getId())) continue;
            arrayList.add(EfaTransformHelper.createEfaLocation(vAUDESObjekt, efaStammLage));
        }
        return arrayList;
    }

    private static Set<Short> collectEfaLocationIdsForEfaErrorObjectParentId(int n, List<VAUDESObjekt> list) {
        HashSet<Short> hashSet = new HashSet<Short>();
        for (VAUDESObjekt vAUDESObjekt : list) {
            for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                if (efaStammFehlerObjektTYPE.getId() != n || null == efaStammFehlerObjektTYPE.getEfaLagen()) continue;
                for (EfaLageTYPE efaLageTYPE : efaStammFehlerObjektTYPE.getEfaLagen().getEfaLage()) {
                    hashSet.add(efaLageTYPE.getId());
                }
            }
        }
        return hashSet;
    }

    public static Set<IEfaCondition> getTopLevelEfaConditions() {
        HashSet<IEfaCondition> hashSet;
        block5: {
            VAUDESObjekt vAUDESObjekt;
            VAUDESObjekt vAUDESObjekt2;
            block6: {
                block4: {
                    hashSet = new HashSet<IEfaCondition>();
                    vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
                    vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
                    if (null == vAUDESObjekt || null != vAUDESObjekt2) break block4;
                    for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
                        if (null != efaStammRandbedingung.getParentId()) continue;
                        hashSet.add(EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung));
                    }
                    break block5;
                }
                if (null == vAUDESObjekt || null == vAUDESObjekt2) break block6;
                ArrayList<IEfaCondition> arrayList = new ArrayList<IEfaCondition>();
                ArrayList<IEfaCondition> arrayList2 = new ArrayList<IEfaCondition>();
                for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt.getEfaCodes().getEfaStammRandbedingung()) {
                    if (null != efaStammRandbedingung.getParentId()) continue;
                    arrayList.add(EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt, efaStammRandbedingung));
                }
                for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt2.getEfaCodes().getEfaStammRandbedingung()) {
                    if (null != efaStammRandbedingung.getParentId()) continue;
                    arrayList2.add(EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt2, efaStammRandbedingung));
                }
                EfaTransformHelper.mergeEfaConditions(arrayList2, arrayList);
                hashSet.addAll(arrayList2);
                break block5;
            }
            if (null != vAUDESObjekt || null == vAUDESObjekt2) break block5;
            for (EfaStammRandbedingung efaStammRandbedingung : vAUDESObjekt2.getEfaCodes().getEfaStammRandbedingung()) {
                if (null != efaStammRandbedingung.getParentId()) continue;
                hashSet.add(EfaTransformHelper.createEfaConditionObjectFrom(vAUDESObjekt2, efaStammRandbedingung));
            }
        }
        return hashSet;
    }

    public static Set<IEfaErrorObject> getEfaTopLevelErrorObjects() {
        HashSet<IEfaErrorObject> hashSet;
        block5: {
            VAUDESObjekt vAUDESObjekt;
            VAUDESObjekt vAUDESObjekt2;
            block6: {
                block4: {
                    hashSet = new HashSet<IEfaErrorObject>();
                    vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
                    vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
                    if (null == vAUDESObjekt || null != vAUDESObjekt2) break block4;
                    for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                        if (null != efaStammFehlerObjektTYPE.getParentId()) continue;
                        hashSet.add(EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt, efaStammFehlerObjektTYPE));
                    }
                    break block5;
                }
                if (null == vAUDESObjekt || null == vAUDESObjekt2) break block6;
                ArrayList<IEfaErrorObject> arrayList = new ArrayList<IEfaErrorObject>();
                ArrayList<IEfaErrorObject> arrayList2 = new ArrayList<IEfaErrorObject>();
                for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt.getEfaCodes().getEfaStammFehlerObjekt()) {
                    if (null != efaStammFehlerObjektTYPE.getParentId()) continue;
                    arrayList.add(EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt, efaStammFehlerObjektTYPE));
                }
                for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt2.getEfaCodes().getEfaStammFehlerObjekt()) {
                    if (null != efaStammFehlerObjektTYPE.getParentId()) continue;
                    arrayList2.add(EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt2, efaStammFehlerObjektTYPE));
                }
                EfaTransformHelper.mergeEfaErrorObjects(arrayList2, arrayList);
                hashSet.addAll(arrayList2);
                break block5;
            }
            if (null != vAUDESObjekt || null == vAUDESObjekt2) break block5;
            for (EfaStammFehlerObjektTYPE efaStammFehlerObjektTYPE : vAUDESObjekt2.getEfaCodes().getEfaStammFehlerObjekt()) {
                if (null != efaStammFehlerObjektTYPE.getParentId()) continue;
                hashSet.add(EfaTransformHelper.createEfaErrorObjectFrom(vAUDESObjekt2, efaStammFehlerObjektTYPE));
            }
        }
        return hashSet;
    }

    public static Set<IEfaErrorType> getEfaTopLevelErrorTypes() {
        HashSet<IEfaErrorType> hashSet;
        block5: {
            VAUDESObjekt vAUDESObjekt;
            VAUDESObjekt vAUDESObjekt2;
            block6: {
                block4: {
                    hashSet = new HashSet<IEfaErrorType>();
                    vAUDESObjekt2 = EfaTransformHelper.getEfaObjFromDbIndex();
                    vAUDESObjekt = EfaTransformHelper.getEfaObjFromHookIndex();
                    if (null == vAUDESObjekt || null != vAUDESObjekt2) break block4;
                    for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
                        if (null != efaStammArt.getParentId()) continue;
                        hashSet.add(EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt));
                    }
                    break block5;
                }
                if (null == vAUDESObjekt || null == vAUDESObjekt2) break block6;
                ArrayList<IEfaErrorType> arrayList = new ArrayList<IEfaErrorType>();
                ArrayList<IEfaErrorType> arrayList2 = new ArrayList<IEfaErrorType>();
                for (EfaStammArt efaStammArt : vAUDESObjekt.getEfaCodes().getEfaStammArt()) {
                    if (null != efaStammArt.getParentId()) continue;
                    arrayList.add(EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt, efaStammArt));
                }
                for (EfaStammArt efaStammArt : vAUDESObjekt2.getEfaCodes().getEfaStammArt()) {
                    if (null != efaStammArt.getParentId()) continue;
                    arrayList2.add(EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt2, efaStammArt));
                }
                EfaTransformHelper.mergeEfaTypes(arrayList2, arrayList);
                hashSet.addAll(arrayList2);
                break block5;
            }
            if (null != vAUDESObjekt || null == vAUDESObjekt2) break block5;
            for (EfaStammArt efaStammArt : vAUDESObjekt2.getEfaCodes().getEfaStammArt()) {
                if (null != efaStammArt.getParentId()) continue;
                hashSet.add(EfaTransformHelper.createEfaErrorTypeFrom(vAUDESObjekt2, efaStammArt));
            }
        }
        return hashSet;
    }

    public static void mergeEfaConditions(Collection<IEfaCondition> collection, Collection<IEfaCondition> collection2) {
        if (collection.isEmpty()) {
            collection.addAll(collection2);
            return;
        }
        ArrayList<IEfaCondition> arrayList = new ArrayList<IEfaCondition>();
        block0: for (IEfaCondition iEfaCondition : collection) {
            for (IEfaCondition iEfaCondition2 : collection2) {
                if (iEfaCondition.getConditionKey().getValue() != iEfaCondition2.getConditionKey().getValue()) continue;
                EfaTransformHelper.adjustEfaCondition(iEfaCondition, iEfaCondition2);
                arrayList.add(iEfaCondition2);
                continue block0;
            }
        }
        collection2.removeAll(arrayList);
        collection.addAll(collection2);
    }

    public static void mergeEfaLocations(Collection<IEfaLocation> collection, Collection<IEfaLocation> collection2) {
        if (collection.isEmpty()) {
            collection.addAll(collection2);
            return;
        }
        ArrayList<IEfaLocation> arrayList = new ArrayList<IEfaLocation>();
        block0: for (IEfaLocation iEfaLocation : collection) {
            for (IEfaLocation iEfaLocation2 : collection2) {
                if (iEfaLocation.getLocationKey().getValue() != iEfaLocation2.getLocationKey().getValue()) continue;
                EfaTransformHelper.adjustEfaLocation(iEfaLocation, iEfaLocation2);
                arrayList.add(iEfaLocation2);
                continue block0;
            }
        }
        collection2.removeAll(arrayList);
        collection.addAll(collection2);
    }

    public static void mergeEfaErrorObjects(Collection<IEfaErrorObject> collection, Collection<IEfaErrorObject> collection2) {
        if (collection.isEmpty()) {
            collection.addAll(collection2);
            return;
        }
        ArrayList<IEfaErrorObject> arrayList = new ArrayList<IEfaErrorObject>();
        block0: for (IEfaErrorObject iEfaErrorObject : collection) {
            for (IEfaErrorObject iEfaErrorObject2 : collection2) {
                if (iEfaErrorObject.getErrorObjectKey().getValue() != iEfaErrorObject2.getErrorObjectKey().getValue()) continue;
                EfaTransformHelper.adjustEfaErrorObject(iEfaErrorObject, iEfaErrorObject2);
                arrayList.add(iEfaErrorObject2);
                continue block0;
            }
        }
        collection2.removeAll(arrayList);
        collection.addAll(collection2);
    }

    public static void mergeEfaTypes(Collection<IEfaErrorType> collection, Collection<IEfaErrorType> collection2) {
        if (collection.isEmpty()) {
            collection.addAll(collection2);
            return;
        }
        ArrayList<IEfaErrorType> arrayList = new ArrayList<IEfaErrorType>();
        block0: for (IEfaErrorType iEfaErrorType : collection) {
            for (IEfaErrorType iEfaErrorType2 : collection2) {
                if (iEfaErrorType.getErrorTypeKey().getValue() != iEfaErrorType2.getErrorTypeKey().getValue()) continue;
                EfaTransformHelper.adjustEfaErrorType(iEfaErrorType, iEfaErrorType2);
                arrayList.add(iEfaErrorType2);
                continue block0;
            }
        }
        collection2.removeAll(arrayList);
        collection.addAll(collection2);
    }

    public static ITranslatedText getEfaText(String string, Locale locale) {
        ITranslatedText iTranslatedText = null;
        ITextId iTextId = DbgHookTransformHelper.createTextIdFrom("EfaCodes", string);
        IndicatedElement indicatedElement = ObjectIndicator.getInstance().getObjectByIdOrSysName("EfaCodes");
        if (null != indicatedElement) {
            iTranslatedText = TranslatedTextTransformHelper.getTranslatedTextFrom(indicatedElement, locale, iTextId);
        }
        if (null == iTranslatedText) {
            try {
                iTranslatedText = DatabaseResolver.getInstance().getTranslatedText("EfaCodes", locale, iTextId);
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                LOG.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
            }
        }
        return iTranslatedText;
    }
}

