/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.IOdisEcuReference;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDiagnosticObject;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentInheritance;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ISuspicion;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookDiagnosticObjectWrapper;
import de.vw.vaudes.diaghook.dto.HookDocumentInheritanceWrapper;
import de.vw.vaudes.diaghook.dto.HookOdisEcuReferenceWrapper;
import de.vw.vaudes.diaghook.dto.HookSuspicionWrapper;
import de.vw.vaudes.diaghook.factory.OverlayingFactoryObjectResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.Diagnoseobjekt;
import de.vw.vaudes.xml.object.Fehlerausdruck;
import de.vw.vaudes.xml.object.GewichtungDOM;
import de.vw.vaudes.xml.object.ObjektverweisByObjektIdTYPE;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DiagnosticObjTransformHelper {
    private static final Log LOG = LogFactory.getLog(DiagnosticObjTransformHelper.class);

    private DiagnosticObjTransformHelper() {
    }

    public static void adjustDiagnosticObjects(IDiagnosticObject iDiagnosticObject, IDiagnosticObject iDiagnosticObject2) {
        iDiagnosticObject.setDiagObjectGfsId(iDiagnosticObject2.getDiagObjectGfsId());
        iDiagnosticObject.setDiagObjectKey(iDiagnosticObject2.getDiagObjectKey());
        iDiagnosticObject.setEcuReference(iDiagnosticObject2.getEcuReference());
        iDiagnosticObject.setExecutionMode(iDiagnosticObject2.getExecutionMode());
        iDiagnosticObject.setInternal(iDiagnosticObject2.getInternal());
        iDiagnosticObject.setKeepTestProgramSequence(iDiagnosticObject2.getKeepTestProgramSequence());
        iDiagnosticObject.setName(iDiagnosticObject2.getName());
        iDiagnosticObject.setVariantRule(iDiagnosticObject2.getVariantRule());
    }

    public static List<IDiagnosticObject> getDiagnosticChildObjectsFrom(VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        ArrayList<IDiagnosticObject> arrayList = new ArrayList<IDiagnosticObject>();
        Iterator<ObjektverweisByObjektIdTYPE> iterator = null;
        if (null != vAUDESObjekt.getDiagnoseobjekt()) {
            if (null == vAUDESObjekt.getDiagnoseobjekt().getHatDiagnoseobjekte()) {
                return arrayList;
            }
            iterator = vAUDESObjekt.getDiagnoseobjekt().getHatDiagnoseobjekte().getVerweis().iterator();
        } else if (null != vAUDESObjekt.getWissensbasis() && null != vAUDESObjekt.getWissensbasis().getHatDiagnoseobjekte()) {
            iterator = vAUDESObjekt.getWissensbasis().getHatDiagnoseobjekte().getVerweis().iterator();
        }
        while (null != iterator && iterator.hasNext()) {
            ObjektverweisByObjektIdTYPE objektverweisByObjektIdTYPE = iterator.next();
            try {
                VAUDESObjekt vAUDESObjekt2;
                Object object = DiagnosticDataAccessHelper.parseFile(objektverweisByObjektIdTYPE.getObjektRef(), VAUDESObjekt.class);
                if (!(object instanceof VAUDESObjekt)) {
                    LOG.warn((Object)("Referenced diagnostic object not found in index: " + objektverweisByObjektIdTYPE.getObjektRef()));
                    vAUDESObjekt2 = OverlayingFactoryObjectResolver.getInstance().getDiagnosticObject(objektverweisByObjektIdTYPE.getObjektRef());
                    if (null == vAUDESObjekt2) continue;
                    arrayList.add((IDiagnosticObject)vAUDESObjekt2);
                    continue;
                }
                vAUDESObjekt2 = (VAUDESObjekt)object;
                arrayList.add(DiagnosticObjTransformHelper.createDiagnosticObjectFrom(vAUDESObjekt2));
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while parsing object with id " + objektverweisByObjektIdTYPE.getObjektRef()), (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static IDiagnosticObject createDiagnosticObjectFrom(VAUDESObjekt vAUDESObjekt) {
        HookDiagnosticObjectWrapper hookDiagnosticObjectWrapper = new HookDiagnosticObjectWrapper();
        boolean bl = DiagnosticObjTransformHelper.transformDiagnosticObject(hookDiagnosticObjectWrapper, vAUDESObjekt);
        if (!bl) {
            return null;
        }
        return hookDiagnosticObjectWrapper;
    }

    private static int getDiagnosticObjectExecutionModeMapping(Diagnoseobjekt diagnoseobjekt) {
        String string = diagnoseobjekt.getAusfuehrungsmodus();
        int n = 0;
        if (string.equalsIgnoreCase("GefuehrteFehlersuche")) {
            n = 1;
        } else if (string.equalsIgnoreCase("GefuehrteFunktion")) {
            n = 2;
        } else if (string.equalsIgnoreCase("UebergeordneteFunktion")) {
            n = 3;
        } else if (string.equalsIgnoreCase("GefuehrteUebergeordneteFunktion")) {
            n = 4;
        }
        return n;
    }

    public static boolean transformDiagnosticObject(IDiagnosticObject iDiagnosticObject, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getDiagnoseobjekt()) {
            LOG.warn((Object)"Attempt to transform a non-diagnostic object to a diagnostic object");
            return bl;
        }
        bl = true;
        iDiagnosticObject.setDiagObjectKey(vAUDESObjekt.getId());
        iDiagnosticObject.setExecutionMode(DiagnosticObjTransformHelper.getDiagnosticObjectExecutionModeMapping(vAUDESObjekt.getDiagnoseobjekt()));
        if (null != vAUDESObjekt.getDiagnoseobjekt().getSGReferenz()) {
            iDiagnosticObject.setEcuReference((IOdisEcuReference)new HookOdisEcuReferenceWrapper(vAUDESObjekt.getDiagnoseobjekt().getSGReferenz()));
        }
        iDiagnosticObject.setInternal(vAUDESObjekt.getDiagnoseobjekt().isIstIntern());
        iDiagnosticObject.setKeepTestProgramSequence(vAUDESObjekt.getDiagnoseobjekt().isReihenfolge());
        if (null != vAUDESObjekt.getDiagnoseobjekt().getVariantenregel()) {
            iDiagnosticObject.setVariantRule(DbgHookTransformHelper.transformVariantRule(vAUDESObjekt.getDiagnoseobjekt().getVariantenregel()));
        }
        if (null != vAUDESObjekt.getAnzeigename()) {
            iDiagnosticObject.setName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
        } else {
            iDiagnosticObject.setName(null);
        }
        iDiagnosticObject.setDiagObjectGfsId(vAUDESObjekt.getSystemname());
        return bl;
    }

    public static List<ISuspicion> getSuspicionsFromDiagnosticObject(VAUDESObjekt vAUDESObjekt) {
        ArrayList<ISuspicion> arrayList = new ArrayList<ISuspicion>();
        if (null == vAUDESObjekt.getDiagnoseobjekt()) {
            LOG.warn((Object)"Attempt to transform a non-diagnostic object to a diagnostic object");
            return arrayList;
        }
        if (null != vAUDESObjekt.getDiagnoseobjekt().getFehlerausdruck()) {
            int n = 0;
            Iterator<Fehlerausdruck> iterator = vAUDESObjekt.getDiagnoseobjekt().getFehlerausdruck().iterator();
            while (iterator.hasNext()) {
                try {
                    Fehlerausdruck fehlerausdruck = iterator.next();
                    HookSuspicionWrapper hookSuspicionWrapper = new HookSuspicionWrapper();
                    hookSuspicionWrapper.setDiagObjectKey(vAUDESObjekt.getId());
                    hookSuspicionWrapper.setFaultExpression(DbgHookTransformHelper.transformFaultExpression(fehlerausdruck));
                    hookSuspicionWrapper.setSuspicionNr(n);
                    hookSuspicionWrapper.setSuspicionWeight(DiagnosticObjTransformHelper.transformFaultExpressionGewichtung(fehlerausdruck));
                    arrayList.add(hookSuspicionWrapper);
                    ++n;
                }
                catch (Exception exception) {
                    LOG.error((Object)"error while transforming suspicions", (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public static int transformFaultExpressionGewichtung(Fehlerausdruck fehlerausdruck) {
        int n = 0;
        if (fehlerausdruck.getGewicht().equals((Object)GewichtungDOM.MITTEL)) {
            n = 50;
        } else if (fehlerausdruck.getGewicht().equals((Object)GewichtungDOM.HOCH)) {
            n = 100;
        }
        return n;
    }

    public static void adjustDocumentInheritances(IDocumentInheritance iDocumentInheritance, HookDocumentInheritanceWrapper hookDocumentInheritanceWrapper) {
        iDocumentInheritance.setDiagObjectKey(hookDocumentInheritanceWrapper.getDiagObjectKey());
        iDocumentInheritance.setDirection(hookDocumentInheritanceWrapper.getDirection());
        iDocumentInheritance.setDirection(hookDocumentInheritanceWrapper.getDirectionText());
        iDocumentInheritance.setDocCategory(hookDocumentInheritanceWrapper.getDocCategoryText());
        iDocumentInheritance.setDocCategory(hookDocumentInheritanceWrapper.getDocCategory());
        iDocumentInheritance.setVariantRule(hookDocumentInheritanceWrapper.getVariantRule());
    }

    public static void adjustSuspicions(ISuspicion iSuspicion, ISuspicion iSuspicion2) {
        iSuspicion.setDiagObjectKey(iSuspicion2.getDiagObjectKey());
        iSuspicion.setFaultExpression(iSuspicion2.getFaultExpression());
        iSuspicion.setSuspicionNr(iSuspicion2.getSuspicionNr());
        iSuspicion.setSuspicionWeight(iSuspicion2.getSuspicionWeight());
    }

    public static boolean transformKnowledgeBaseObject(IDiagnosticObject iDiagnosticObject, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getWissensbasis()) {
            LOG.warn((Object)"Attempt to transform a non-knowledge base object to a knowledge base object");
        } else {
            bl = true;
            iDiagnosticObject.setDiagObjectGfsId(vAUDESObjekt.getSystemname());
            iDiagnosticObject.setDiagObjectKey(vAUDESObjekt.getId());
            if (null != vAUDESObjekt.getAnzeigename()) {
                iDiagnosticObject.setName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
            } else {
                iDiagnosticObject.setName(null);
            }
        }
        return bl;
    }

    public static IDiagnosticObject createKnowledgeBaseRoot(VAUDESObjekt vAUDESObjekt) {
        HookDiagnosticObjectWrapper hookDiagnosticObjectWrapper = null;
        HookDiagnosticObjectWrapper hookDiagnosticObjectWrapper2 = new HookDiagnosticObjectWrapper();
        boolean bl = DiagnosticObjTransformHelper.transformKnowledgeBaseObject(hookDiagnosticObjectWrapper2, vAUDESObjekt);
        if (bl) {
            hookDiagnosticObjectWrapper = hookDiagnosticObjectWrapper2;
        }
        return hookDiagnosticObjectWrapper;
    }
}

