/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.fkc;

import de.vw.vaudes.diaghook.index.fkc.FkcMetaData;
import de.vw.vaudes.diaghook.index.fkc.FunctiontestDigester;
import de.vw.vaudes.diaghook.util.JaxbUtils;
import de.vw.vaudes.diaghook.util.Pair;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FunctiontestIndicator {
    private static final Log LOGGER = LogFactory.getLog(FunctiontestIndicator.class);
    private static final FunctiontestIndicator FGINSTANCE = new FunctiontestIndicator();
    private final Map<String, Pair<VAUDESStringTabelle, FkcMetaData>> fFunctiontestObjectIndex = new HashMap<String, Pair<VAUDESStringTabelle, FkcMetaData>>();
    private final Map<String, Pair<VAUDESStringTabelle, FkcMetaData>> fFunctiontestSysnameIndex = new HashMap<String, Pair<VAUDESStringTabelle, FkcMetaData>>();

    private FunctiontestIndicator() {
    }

    public static FunctiontestIndicator getInstance() {
        return FGINSTANCE;
    }

    public void indicateFunctiontest(File file) {
        FunctiontestDigester functiontestDigester = new FunctiontestDigester();
        this.fFunctiontestObjectIndex.clear();
        this.fFunctiontestSysnameIndex.clear();
        try {
            if (file.isDirectory()) {
                return;
            }
            functiontestDigester.run(file);
            String string = StringUtils.substringBeforeLast((String)file.getAbsolutePath(), (String)File.separator) + File.separator + functiontestDigester.getTextFile();
            VAUDESStringTabelle vAUDESStringTabelle = JaxbUtils.unmarshal(new File(string).toURI().toString(), VAUDESStringTabelle.class);
            FkcMetaData fkcMetaData = new FkcMetaData(functiontestDigester, vAUDESStringTabelle.getObjektRef());
            this.fFunctiontestObjectIndex.put(vAUDESStringTabelle.getObjektRef(), new Pair<VAUDESStringTabelle, FkcMetaData>(vAUDESStringTabelle, fkcMetaData));
            this.fFunctiontestSysnameIndex.put(fkcMetaData.getModuleId(), new Pair<VAUDESStringTabelle, FkcMetaData>(vAUDESStringTabelle, fkcMetaData));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error during functiontest indication", (Throwable)exception);
        }
    }

    public Pair<VAUDESStringTabelle, FkcMetaData> getFkcMetaDataFor(String string) {
        Pair<VAUDESStringTabelle, FkcMetaData> pair = this.fFunctiontestObjectIndex.get(string);
        if (null == pair) {
            pair = this.fFunctiontestSysnameIndex.get(string);
        }
        return pair;
    }

    public void clearIndex() {
        this.fFunctiontestObjectIndex.clear();
        this.fFunctiontestSysnameIndex.clear();
    }
}

