@echo OFF
REM #############################################
REM ### VAS6910 Installer #######################
REM #############################################

REM V1.0.6 -- 20.02.2025 -- # [OS] [  ] - Product-Key zum Loeschen hinzugefuegt (Modulebalancer Version 1.1.6)
REM V1.0.5 -- 31.01.2025 -- # [OS] [  ] - Product-Key zum Loeschen hinzugefuegt
REM V1.0.4 -- 23.09.2024 -- # [OS] [  ] - Product-Key zum Loeschen hinzugefuegt
REM V1.0.3 -- 27.08.2024 -- # [OS] [  ] - Product-Key zum Loeschen hinzugefuegt
REM V1.0.2 -- 05.06.2023 -- # [OS] [  ] - Product-Key zum Loeschen hinzugefuegt
REM V1.0.1 -- 05.06.2023 -- # [OS] [  ] - Product-Keys zum Loeschen hinzugefuegt
REM V1.0.0 -- Initialisierung VAS6910 Installer

set SCRIPTVERSION=105
SET "path=%path%;C:\Windows\;C:\Windows\System32\;C:\Windows\System32\wbem"

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
if not exist "%programdata%\Diag_SetupLogs" md "%programdata%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\VAS6910_Installer_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""



REM ####################################################
REM ### Install & Uninstall ############################
REM ####################################################
call :LOG ###
call :LOG "%time%" "Uninstall previous versions:"
echo Uninstall previous versions
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :UNINSTALL 0F5F01A0-0E2C-42B8-926A-3A9B3CF3460C
call :UNINSTALL 4AA2A454-DF88-4776-80B8-C7497A63EED5
call :UNINSTALL EDE79B27-EE0A-477C-B2AA-83CA4C70CB3C
call :UNINSTALL 1DDAEE8E-F357-4152-9B44-E2A4727CCEB4
call :UNINSTALL 4A5DC20E-417A-46B8-AE8B-8576D13126C9
call :UNINSTALL 9AC0DE07-134D-4FE9-8062-D50DBD0B82C9
call :UNINSTALL 7E20A6EC-D609-41B2-9703-E459817FD915
call :UNINSTALL 7CDDC3FC-A494-47CD-831B-CBD8AB433413
call :UNINSTALL 7A806937-2C0E-48B0-9B94-DEADDB96072B

call :LOG ###
call :LOG "%time%" "Install new Version of DeviceAPI_gRPC_Server_Win_SCE.msi:"
echo Install new Version of DeviceAPI_gRPC_Server_Win_SCE.msi:
cd %~dp0
msiexec /i DeviceAPI_gRPC_Server_Win_SCE.msi /quiet /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"

call :LOG ###
call :LOG "%time%" "Terminating script with: %wert%"
exit /B %wert%



REM ####################################################
REM ### Tools ##########################################
REM ####################################################

REM ####################################################
REM ### MSI UNINSTALLER ################################
REM ####################################################
:UNINSTALL
call :LOG "%time%" "- - - uninstalling MsiExec Code %1  - - - - - - - -"
MsiExec /x {%1} /qn /norestart /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" "- - - RETURNCODE: %wert%  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
goto :EOF



REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### VAS6910 Installer       ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF